package com.bxm.localnews.activity.record.utils;

import it.sauronsoftware.jave.Encoder;
import it.sauronsoftware.jave.MultimediaInfo;
import lombok.extern.slf4j.Slf4j;

import java.io.File;

/**
 * 录音文件工具类
 * @author liujia
 */
@Slf4j
public class RecordUtils {
    static String[] units = {"", "十", "百", "千", "万", "十万", "百万", "千万", "亿", "十亿", "百亿", "千亿", "万亿"};

    static char[] numArray = {'零', '一', '二', '三', '四', '五', '六', '七', '八', '九'};

    private RecordUtils() {

    }

    /**
     * 获取录音文件时长
     * @param recordFile 录音文件
     * @return 录音文件时长（时长：秒）
     */
    public static int getDuration(File recordFile) {
        Encoder encoder = new Encoder();
        long ls = 0;
        MultimediaInfo m;
        try {
            m = encoder.getInfo(recordFile);
            ls = m.getDuration() / 1000;

        } catch (Exception e) {
            log.error("获取录音时长错误，文件为：" + recordFile, e);
        }
        return (int) ls;
    }

    /**
     * 将整数转换成汉字数字
     * @param num
     * @return
     */
    public static String formatInteger(int num) {
        char[] val = String.valueOf(num).toCharArray();
        int len = val.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; i++) {
            String m = val[i] + "";
            int n = Integer.valueOf(m);
            boolean isZero = n == 0;
            String unit = units[(len - 1) - i];
            if (isZero && '0' != val[i - 1]) {
                sb.append(numArray[n]);
            } else {
                sb.append(numArray[n]);
                sb.append(unit);
            }
        }
        return sb.toString();
    }

    /**
     * 将小数转换成汉字数字
     * 超过10万的转换有问题
     * @param decimal
     * @return
     */
    public static String formatDecimal(double decimal) {
        String decimals = String.valueOf(decimal);
        int decIndex = decimals.indexOf(".");
        int integ = Integer.valueOf(decimals.substring(0, decIndex));
        int dec = Integer.valueOf(decimals.substring(decIndex + 1));
        String result = formatInteger(integ);
        if (0 != dec) {
            result += "点" + formatFractionalPart(dec);
        }
        return result;
    }

    /**
     * 格式化小数部分的数字
     * @param decimal
     * @return
     */
    private static String formatFractionalPart(int decimal) {
        char[] val = String.valueOf(decimal).toCharArray();
        int len = val.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; i++) {
            int n = Integer.valueOf(val[i] + "");
            sb.append(numArray[n]);
        }
        return sb.toString();
    }
}
