package com.bxm.localnews.activity.service.impl;

import com.bxm.localnews.activity.constant.CouponLabelEnum;
import com.bxm.localnews.activity.domain.CouponMapper;
import com.bxm.localnews.activity.dto.CouponDTO;
import com.bxm.localnews.activity.dto.CouponDetailDTO;
import com.bxm.localnews.activity.param.CouponParam;
import com.bxm.localnews.activity.service.CouponService;
import com.bxm.localnews.activity.vo.Coupon;
import com.bxm.newidea.component.vo.PageWarper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class CouponServiceImpl implements CouponService {

    @Autowired
    private CouponMapper couponMapper;

    @Override
    public PageWarper<CouponDTO> listCoupon(CouponParam couponParam) {
        List<Coupon> couponList = couponMapper.queryByPageSize(couponParam);
        PageWarper pageWarper = new PageWarper<>(couponList);

        //按日销量排序
        List<CouponDTO> couponDTOList = couponList.stream()
                .sorted(Comparator.comparing(Coupon::getDaySales).reversed())
                .map(this::convertCoupon).collect(Collectors.toList());

        fillingCouponDto(couponDTOList);

        pageWarper.setList(couponDTOList);

        return pageWarper;
    }

    private CouponDTO convertCoupon(Coupon coupon) {
        CouponDTO couponDTO = new CouponDTO();
        BeanUtils.copyProperties(coupon, couponDTO);
        return couponDTO;
    }


    /**
     * 填补优惠券标签[9.9包邮]和[超级省]交替
     * @param couponDTOList
     */
    private void fillingCouponDto(List<CouponDTO> couponDTOList) {
        Iterator<CouponDTO> it = couponDTOList.iterator();
        int size = couponDTOList.size();

        for (int i = 0; i < size; i++) {
            CouponDTO c = it.next();
            if ((i & 1) != 1) {
                c.setLabel(CouponLabelEnum.SHIPPING_99.getDesc());
            } else {
                c.setLabel(CouponLabelEnum.SAVE_MONEY.getDesc());
            }
        }
    }

    @Override
    public CouponDetailDTO getCouponDetail(Long id) {
        Coupon coupon = couponMapper.selectByPrimaryKey(id);
        CouponDetailDTO couponDetailDTO = new CouponDetailDTO();
        BeanUtils.copyProperties(coupon, couponDetailDTO);
        return couponDetailDTO;
    }
}
