package com.bxm.localnews.activity.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.component.httpclient.service.OKHttpService;
import com.bxm.localnews.activity.service.DingDingMsgService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * <p>
 *     发送钉钉消息
 * </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/4/29
 */
@Service
public class DingDingMsgServiceImpl implements DingDingMsgService {
    private final static Logger LOG = LoggerFactory.getLogger(DingDingMsgServiceImpl.class);

    @Value("${dingding.robot.webhook}")
    private String        webhook;
    @Autowired
    private OKHttpService okHttpService;

    @Async
    @Override
    public void sendExamine(Long userId) {
        if(null == webhook){
            LOG.warn("钉钉消息链接为空!");
            return;
        }

        String content = "用户："+userId+" 发红包啦，请审核！@+86-18903812792";
        JSONObject text = new JSONObject();
        text.put("content", content);

        JSONObject at = new JSONObject();
        at.put("atMobiles", Lists.newArrayList("+86-18903812792"));
        at.put("isAtAll", false);

        JSONObject msg = new JSONObject();
        msg.put("msgtype", "text");
        msg.put("text", text);
        msg.put("at",at);

        okHttpService.postJsonBody(this.webhook,msg.toJSONString(),Maps.newHashMap());
    }
}
