package com.bxm.localnews.activity.service.impl;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import com.bxm.localnews.activity.common.constant.TaskStateEnum;
import com.bxm.localnews.activity.common.constant.TaskTypeEnum;
import com.bxm.localnews.activity.domain.BrowseRecordMapper;
import com.bxm.localnews.activity.domain.DailyTaskMapper;
import com.bxm.localnews.activity.domain.NoviceTaskRecordMapper;
import com.bxm.localnews.activity.dto.AppletAppTaskResultDTO;
import com.bxm.localnews.activity.service.MissionService;
import com.bxm.localnews.activity.service.VipService;
import com.bxm.localnews.activity.vo.*;
import com.bxm.localnews.base.dto.LocationFacadeDTO;
import com.bxm.localnews.base.service.AppVersionSupplyService;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.config.NewsProperties;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.common.constant.WxMiniSceneEnum;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.dto.LocationDetailDTO;
import com.bxm.localnews.facade.PushMsgSupplyFeignService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.integration.UserAuthIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.localnews.thirdparty.dto.AdvertDTO;
import com.bxm.localnews.thirdparty.service.AdvertService;
import com.bxm.localnews.thirdparty.service.WxMpFacadeService;
import com.bxm.localnews.vo.User;
import com.bxm.localnews.vo.UserAuth;
import com.bxm.newidea.component.log.LogMarker;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.gexin.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import static com.bxm.localnews.activity.vo.DailyTask.*;
import static com.bxm.localnews.activity.vo.UserMissionModel.TASK_STATE_NO;
import static com.bxm.localnews.activity.vo.UserMissionModel.TASK_STATE_YES;
import static com.bxm.localnews.common.constant.RedisConfig.*;
import static com.bxm.localnews.common.constant.TaskEnum.*;

/**
 * Created by Administrator on 2018/2/23.
 */
@Service("missionService")
public class MissionServiceImpl extends BaseService implements MissionService {

    private final static Logger logger = LoggerFactory.getLogger(MissionServiceImpl.class);

    @Resource
    private DailyTaskMapper dailyTaskMapper;

    @Resource
    private UserAccountIntegrationService userAccountIntegrationService;

    @Resource
    private RedisStringAdapter redisStringAdapter;

    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Resource
    private NoviceTaskRecordMapper noviceTaskRecordMapper;

    @Resource
    private PushMsgSupplyFeignService pushMsgSupplyFeignService;

    @Resource
    private LocationFacadeService locationFacadeService;

    @Resource
    private NewsProperties newsProperties;

    @Resource
    private UserIntegrationService userIntegrationService;

    @Resource
    private VipService vipService;

    @Resource
    private AdvertService advertService;

    @Resource
    private AppVersionSupplyService appVersionSupplyService;

    @Resource
    private BizConfigProperties bizConfigProperties;

    @Resource
    private DistributedLock distributedLock;

    @Resource
    private SequenceCreater sequenceCreater;

    @Resource
    private BrowseRecordMapper browseRecordMapper;

    @Resource
    private WxMpFacadeService wxMpFacadeService;

    @Resource
    private UserAuthIntegrationService userAuthIntegrationService;

    @Override
    public Json<MissionModel> listMissions(Long userId, String areaCode, String curVer, Integer platform) {
        MissionModel retModel = new MissionModel();

        Map<String, Byte> dailyTaskMap = this.getDailyTaskStatus(userId);
        //获取用户任务
        List<UserMissionModel> userTask = getUserTaskByPlatform(userId, platform);

        int count = 0;
        LocationFacadeDTO locationFacadeDTO = getLocation(userId, areaCode);
        Boolean isPost = checkPost(locationFacadeDTO);

        for (UserMissionModel model : userTask) {
            model.setColor(TaskEnum.getTaskByType(model.getTaskType()).getColor());
            //替换占位符
            String name = model.getName();
            if (StringUtils.isNotBlank(name) && name.contains("{areaName}")){
                if (Objects.nonNull(locationFacadeDTO) && StringUtils.isNotBlank(locationFacadeDTO.getName())){
                    model.setName(name.replace("{areaName}",locationFacadeDTO.getName()));
                }else{
                    model.setName(name.replace("{areaName}","本地"));
                }
            }
            //判断是新手任务还是日常任务
            if (NEWBIEW_TASK.equals(model.getType())) {
                //新手任务
                //过滤不展示的任务--现需求在过滤新手任务,有需要可以移到if外层做所有任务的判断
                if (filterNotDisplayTaskByNoviceTask(model)) {
                    logger.debug("该任务[{}]不在前端展示", model.getName());
                    continue;
                }
                retModel.addNewbieTask(model);
                if (TASK_STATE_YES == model.getNewbiewTaskState()) {
                    count++;
                }
                if (model.getNewbiewTaskCount() == count) {
                    retModel.setNewbieTaskList(new ArrayList<>());
                }

                //处理新手任务判断
                processNewbieTask(model, userId, isPost);


            } else {
                //日常任务
                TaskEnum taskEnum = TaskEnum.getTaskByType(model.getTaskType());

                processDailyTask(model, taskEnum, userId, isPost, dailyTaskMap, locationFacadeDTO);
                if (taskEnum.equals(TASK_ACTIVATION_VIP) && model.getCompleted()) {
                    continue;
                }
                retModel.addDailyTask(model);
            }


        }
        logger.debug("用户id为[{}]首次处理后的任务信息为:{}", userId, JSON.toJSONString(userTask));

        KeyGenerator userRewardSumKey = RedisConfig.USER_MISSION_REWARD_SUM_PER_DAY.copy()
                .appendKey(userId.toString()).appendKey(DateUtils.formatDate(new Date()));

        logger.debug("从redis获取用户[{}]当天完成任务获得奖励金币总数", userId);

        Long gainGold = redisStringAdapter.getLong(userRewardSumKey);
        retModel.setGainGold(gainGold == null ? null : gainGold.intValue());
        retModel.setTotalGold(newsProperties.getGoldPerDay());
        //排序任务顺序,已完成的任务往后排
        retModel = this.sortResult(retModel);


        //任务广告-判断版本号,调用广告接口并做数据转换
        List<UserMissionModel> advertDailyTaskList = Lists.newArrayList();
        if (StringUtils.isNotBlank(curVer) && appVersionSupplyService.isHighVersion(curVer, "1.2.2") != -1) {
            List<AdvertDTO> advertList = advertService.queryAdByType((byte) 2, areaCode, userId);
            advertDailyTaskList = convertAdvert(advertList);
        }


        List<UserMissionModel> dailyTaskList = retModel.getDailyTaskList();
        //备注：2.1.0版本之前日常任务广告放在前面 2.1.0版本日常任务广告放在后面
//            advertDailyTaskList.addAll(dailyTaskList);
//            retModel.setDailyTaskList(advertDailyTaskList);
        if (!isPost) {
            dailyTaskList = dailyTaskList.stream().filter(userMissionModel -> !userMissionModel.getName().
                    equals(TaskEnum.TASK_POST_INTIVATION.getDesc())).collect(Collectors.toList());
        }
        dailyTaskList.addAll(advertDailyTaskList);
        retModel.setDailyTaskList(dailyTaskList);

        return ResultUtil.genSuccessResult(retModel);

    }

    /**
     * 日常任务广告转换为日常任务
     *
     * @param advertList
     * @return
     */
    private List<UserMissionModel> convertAdvert(List<AdvertDTO> advertList) {
        List<UserMissionModel> dailyTaskList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(advertList)) {
            return dailyTaskList;
        }

        advertList.forEach(advertDTO -> {
            UserMissionModel userMissionModel = new UserMissionModel();
            userMissionModel.setAction(advertDTO.getCopy());
//            userMissionModel.setHeadImg(advertDTO.getImgUrl());
            //2.1.0版本修改- 广告改为广告素材+投放的形式,图片从iconUrl中获取
            userMissionModel.setHeadImg(advertDTO.getIconUrl());
            userMissionModel.setName(advertDTO.getTaskMaintitle());
            userMissionModel.setRemark(advertDTO.getTaskSubtitle());
            userMissionModel.setAddress(advertDTO.getAddress());
            userMissionModel.setType(UserMissionModel.ADVERT_TASK);
            userMissionModel.setId(advertDTO.getId());
            userMissionModel.setMaterialId(advertDTO.getMaterialId());
            dailyTaskList.add(userMissionModel);
        });

        return dailyTaskList;
    }

    /**
     * 是否启用发帖任务
     *
     * @param locationFacadeDTO
     * @return
     */
    private Boolean checkPost(LocationFacadeDTO locationFacadeDTO) {
        if (locationFacadeDTO == null || locationFacadeDTO.getEnableCommunityContent() == 0) {
            return false;
        }
        return true;
    }

    /**
     * 是否显示vip任务
     *
     * @param userId
     */
    private Boolean checkVipAcvation(Long userId, LocationFacadeDTO locationFacadeDTO) {

        if (vipService.checkUserVip(userId) || isShowVipTask(locationFacadeDTO)) {
            return true;
        }

        return false;
    }

    /**
     * 获取地区信息
     *
     * @param areaCode
     * @return
     */
    private LocationFacadeDTO getLocation(Long userId, String areaCode) {
        LocationFacadeDTO locationDTO = null;
        if (StringUtils.isNotEmpty(areaCode)) {
            locationDTO = locationFacadeService.getLocationByCode(areaCode);
        } else {
            //如果没有传地区编号，则去用户表里获取地区编号，如果查不到则说明是未开通地区
            LocationDetailDTO locationDetailDTO = getLocationByUser(userIntegrationService.selectByPrimaryKey(userId));
            if (null != locationDetailDTO) {
                locationDTO = new LocationFacadeDTO();
                BeanUtils.copyProperties(locationDetailDTO, locationDTO);
            }
        }

        return locationDTO;
    }

    /**
     * 如果地区不是开通地区，则隐藏
     *
     * @param locationDTO
     * @return
     */
    private boolean isShowVipTask(LocationFacadeDTO locationDTO) {
        if (locationDTO == null) {
            return false;
        }
        if (0 == locationDTO.getEnableVip()) {
            return true;
        }
        return false;
    }

    private LocationDetailDTO getLocationByUser(User user) {
        LocationDetailDTO locationDetailDTO = null;
        if (user != null) {
            String adcode = user.getLocationCode();
            if (null != adcode) {
                locationDetailDTO = new LocationDetailDTO();
                BeanUtils.copyProperties(locationFacadeService.getLocationDetailByCode(adcode), locationDetailDTO);

            } else {
                locationDetailDTO = new LocationDetailDTO();
                BeanUtils.copyProperties(locationFacadeService.getLocationDetailByCode(bizConfigProperties.getLocationCode()),
                        locationDetailDTO);
            }
        }
        return locationDetailDTO;
    }

    @Override
    public Json<BaskInfoMeta> baskInfo(Long userId) {
        BigDecimal totalCash = this.userAccountIntegrationService.getUserTotalCash(userId);

        BaskInfoMeta meta = new BaskInfoMeta();
        meta.setInviteCode(userId);
        meta.setTotalCoin(totalCash);
        return ResultUtil.genSuccessResult(meta);
    }

    @Override
    public void compleDailyTask(Long userId, Byte taskId) {
        Assert.notNull(taskId, "任务ID不能为空");
        logger.debug(LogMarker.BIZ, "[{}]完成了任务[{}]", userId, taskId);

        KeyGenerator key = getDailyTaskCacheKey(userId);

        this.redisHashMapAdapter.put(key, taskId.toString(), TASK_STATE_YES);
        this.redisHashMapAdapter.expire(key, DateUtils.getCurSeconds());
    }

    private KeyGenerator getDailyTaskCacheKey(Long userId) {
        return DAILY_TASK_COMPELE_STATUS.copy().setKey(DateUtils.formatDate(new Date()) + userId);
    }

    @Override
    public Map<String, Byte> getDailyTaskStatus(Long userId) {
        Assert.notNull(userId, "用户ID不能为空");

        Map<String, Byte> result = this.redisHashMapAdapter.entries(getDailyTaskCacheKey(userId), Byte.class);
        if (result == null) {
            result = Maps.newHashMap();
        }
        return result;
    }

    @Override
    public Long completeTask(Long userId, TaskEnum taskEnum, String relationId,String content) {
        // 每日首次浏览单独处理--转发本地新闻被阅读
        if (TaskEnum.TASK_FISRT_BROWSE.name().equals(taskEnum.name())) {
            return completeTaskForFirstBrower(userId, relationId, taskEnum);
        }
        logger.debug("用户[{}]完成任务类型[{}]---建立邀请关系[{}]", userId, taskEnum.name(), relationId);
        Long reward = null;
        DailyTask dailyTask = dailyTaskMapper.selectByTaskType(taskEnum.getType());
        //任务是否存在
        if (dailyTask == null) {
            return 0L;
        }
        //新手任务是否开启状态（10-关/20-开）
        if (TaskStateEnum.ENABLE != TaskStateEnum.isAble(dailyTask.getState())) {
            return 0L;
        }
        TaskTypeEnum taskType = TaskTypeEnum.getTaskType(dailyTask.getType());
        //新手任务
        if (TaskTypeEnum.NOVICE == taskType) {
            NoviceTaskRecord noviceTaskRecord = noviceTaskRecordMapper.findSelectiveByTaskType(taskEnum.getType(), userId);
            if (noviceTaskRecord == null) {
                noviceTaskRecord = createNoviceTask(dailyTask.getId(), userId);

                logger.debug("完成新手任务,任务信息为:{}", JSON.toJSONString(noviceTaskRecord));

                this.noviceTaskRecordMapper.insertSelective(noviceTaskRecord);
            } else {
                if (noviceTaskRecord.getState() == NoviceTaskRecord.FINISHED) {
                    return 0L;
                }
                noviceTaskRecord.setState(NoviceTaskRecord.FINISHED);
                logger.debug("更新新手任务为完成,任务信息为:{}", JSON.toJSONString(noviceTaskRecord));
                this.noviceTaskRecordMapper.updateByPrimaryKeySelective(noviceTaskRecord);
            }

            logger.info("添加用户[{}]账户的金币和流水,金币[{}], 建立关系的id：[{}]", userId, reward, relationId);
            //添加金币
            AccountGoldParam param = new AccountGoldParam(userId, "USABLE_GOLD", true, dailyTask.getReward().intValue(),
                    relationId == null ? noviceTaskRecord.getId().longValue() : Long.valueOf(relationId), taskEnum.name(),content);
            addUserGold(param);
            //推送
            pushMsgSupplyFeignService.pushMsg(getPushMsgByTask(userId, dailyTask));
            return dailyTask.getReward().longValue();
        } else if (TaskTypeEnum.DAILY == taskType) {
            //日常任务
            int num = dailyTask.getNumber();
            if (num != 0) {
                boolean isOverGoldPerLimit;
                boolean isPush = false;
                boolean isOverNumLimit = false;
                if (num == -1) {
                    isPush = true;
                } else if (num > 0) {
                    KeyGenerator taskCompleteNumKey = null;
                    switch (taskEnum) {
                        case TASK_NEWS_READ:
                            taskCompleteNumKey = NEWS_READ.copy().setKey(userId + DateUtils.PATTERN_NO_DELIMITER_FORMAT.get().format(new Date()));
                            break;
                        case TASK_NEWS_SHARE:
                            taskCompleteNumKey = TASK_SHARE_NEWS_NUM.copy().appendKey(userId.toString()).appendKey(DateUtils.formatDate(new Date()));
                            break;
                        case TASK_VIDEO_READ:
                            taskCompleteNumKey = VIDEO_READ_NUM.copy().appendKey(userId + DateUtils.PATTERN_NO_DELIMITER_FORMAT.get().format(new Date()));
                            break;
                        case TASK_FIRST_POST_INTIVATION:
                        case TASK_POST_INTIVATION:
                            taskCompleteNumKey = POST_FORUM.copy().appendKey(userId + DateUtils.PATTERN_NO_DELIMITER_FORMAT.get().format(new Date()));
                            break;
                        case TASK_COMMENT_NEWS:
                            taskCompleteNumKey = NEWS_COMMENT.copy().appendKey(userId + DateUtils.PATTERN_NO_DELIMITER_FORMAT.get().format(new Date()));
                            break;
                        case TASK_EVERYDAT_SHARE:
                            taskCompleteNumKey = NEWS_SHARE.copy().appendKey(userId + DateUtils.PATTERN_NO_DELIMITER_FORMAT.get().format(new Date()));
                            break;

                        default:
                            logger.error("TASK-ERR--userId:" + userId + ",taskName:" + taskEnum.name());
                            break;
                    }
                    Integer completeNum = redisStringAdapter.getInt(taskCompleteNumKey);
                    if (completeNum == null) {
                        completeNum = 0;
                    }
                    if (completeNum < num) {
                        isOverNumLimit = false;
                        completeNum++;
                        //统计完成次数
                        redisStringAdapter.set(taskCompleteNumKey, completeNum);
                        this.redisStringAdapter.expire(taskCompleteNumKey, DateUtils.getCurSeconds());
                        if (completeNum == num) {
                            isPush = true;
                            this.compleDailyTask(userId, taskEnum.getType());
                        }
                    } else {
                        isOverNumLimit = true;
                    }

                } else {
                    logger.error("TASK-NUMBER-ERR--userId:" + userId + ",taskName:" + taskEnum.name());
                }

                KeyGenerator userRewardSumKey = RedisConfig.USER_MISSION_REWARD_SUM_PER_DAY.copy()
                        .setKey(userId + ":" + DateUtils.formatDate(new Date()));
                Integer totalGoldDay = redisStringAdapter.getInt(userRewardSumKey);

                if ((totalGoldDay == null) || (totalGoldDay != null && totalGoldDay.compareTo(newsProperties.getGoldPerDay()) < 0)) {
                    isOverGoldPerLimit = false;
                } else {
                    isOverGoldPerLimit = true;
                }

                if (!isOverGoldPerLimit && !isOverNumLimit) {
                    //统计当天完成任务获得的金币总数
                    redisStringAdapter.incrementWithDefault(userRewardSumKey, dailyTask.getReward().longValue(), dailyTask.getReward().intValue());
                    redisStringAdapter.expire(userRewardSumKey, DateUtils.getCurSeconds());

                    reward = dailyTask.getReward().longValue();

                    logger.debug("添加用户[{}]账户的金币和流水,金币[{}], 建立关系的id：[{}],完成的任务为:{}", userId, reward, relationId, taskEnum.getDesc());

                    AccountGoldParam param = new AccountGoldParam(userId, "USABLE_GOLD", true,
                            dailyTask.getReward().intValue(), relationId == null ? null : Long.valueOf(relationId),
                            taskEnum.name(),content);
                    addUserGold(param);

                }
                //推送
                if (isPush && !isOverGoldPerLimit) {
                    pushMsgSupplyFeignService.pushMsg(getPushMsgByTask(userId, dailyTask));
                }
            }
        }
        return reward;
    }

    @Override
    public AppletAppTaskResultDTO completeSceneTask(Long userId, String scene) {
        TaskEnum taskEnum = WxMiniSceneEnum.getTaskEnumByScene(scene);
        if (null == taskEnum) {
            logger.error("错误场景值[{}]传入,无法获取对应任务", scene);
            return new AppletAppTaskResultDTO();
        }
        //是否完成新人任务-必须在接下来的'完成任务'步骤前查询
        boolean isCompleteNoviceTask = isCompleteNoviceTask(userId, taskEnum);

        Long taskReward = completeTask(userId, taskEnum, null,null);

        AppletAppTaskResultDTO appletAppTaskResultDTO = new AppletAppTaskResultDTO();

        //判断是'之前未完成的任务'且任务奖金大于0-则弹窗
        if (!isCompleteNoviceTask && taskReward != null && 0 < taskReward) {
            appletAppTaskResultDTO.setPopUpWindowFlag(true);
        }

        appletAppTaskResultDTO.setTaskReward(taskReward);

        return appletAppTaskResultDTO;
    }


    /**
     * 添加用户金币
     *
     * @param param
     */
    private void addUserGold(AccountGoldParam param) {
        String requestId = sequenceCreater.nextStringId();
        String relationId = param.getRelationId() == null ? "null" : param.getRelationId().toString();
        //防止多次同时添加金币
        if (distributedLock.lock(param.getUserId() + relationId, requestId)) {
            userAccountIntegrationService.addGold(param);
            distributedLock.unlock(param.getUserId() + relationId, requestId);
        }
    }

    private PushMessage getPushMsgByTask(Long userId, DailyTask dailyTask) {
        String title = "任务完成";

        Integer goldBalance = userAccountIntegrationService.getUserUsableGold(userId);

        String content = "恭喜你成功完成了【" + dailyTask.getName() + "】,获得" + dailyTask.getReward().longValue() + "朵花,"
                + "目前共有" + goldBalance + "朵花";
        logger.info("推送完成任务消息,用户id为:{},推送消息为:{}", userId, content);

        return PushMessage.build().setTitle(title).setContent(content).setPushReceiveScope(PushReceiveScope.pushSignle(userId))
                .setPayloadInfo(PushPayloadInfo.build(TaskEnum.getPushMessageEnumByDesc(dailyTask.getName()))
                        .addExtend("activityName", dailyTask.getName()).addExtend("activityReward", dailyTask.getReward().longValue() + "")
                        .addExtend("totalGold", goldBalance + ""));
    }

    private MissionModel sortResult(MissionModel retModel) {
        this.sortList(retModel.getNewbieTaskList());
        this.sortList(retModel.getDailyTaskList());
        return retModel;
    }

    private void sortList(List<UserMissionModel> list) {
        list.sort(Comparator.comparingInt(UserMissionModel::getNewbiewTaskState));
    }

    /**
     * 创建任务
     *
     * @param taskId
     * @param userId
     * @return
     */
    private NoviceTaskRecord createNoviceTask(Long taskId, Long userId) {
        NoviceTaskRecord noviceTaskRecord = new NoviceTaskRecord();
        noviceTaskRecord.setState(NoviceTaskRecord.FINISHED);
        noviceTaskRecord.setTaskId(taskId);
        noviceTaskRecord.setUserId(userId);
        Date now = new Date();
        noviceTaskRecord.setCreateTime(now);
        noviceTaskRecord.setUpdateTime(now);
        return noviceTaskRecord;
    }

    /**
     * 根据平台获取用户任务
     *
     * @param userId   用户id
     * @param platform 平台号
     * @return 查询结果
     */
    private List<UserMissionModel> getUserTaskByPlatform(Long userId, Integer platform) {
        List<UserMissionModel> userTask;
        if (5 == platform) {
            //小程序任务
            userTask = this.dailyTaskMapper.listMissions(userId, APPLET_MINI_TYPE);
            logger.debug("从数据库中获取到的小程序任务为:{}", JSON.toJSONString(userTask));
        } else {
            userTask = this.dailyTaskMapper.listMissions(userId, APPLET_APP_TYPE);
            logger.debug("从数据库中获取到的客户端任务为:{}", JSON.toJSONString(userTask));
        }
        return userTask;
    }

    /**
     * 处理新手任务
     *
     * @param model  用户任务传输对象
     * @param userId 用户id
     * @param isPost 是否post
     * @return 处理结果 boolean结果暂不做判断
     */
    private boolean processNewbieTask(UserMissionModel model, Long userId, boolean isPost) {
        //新手任务中完善个人资料
        if (TASK_IMPROVE_INFO.getType() == model.getTaskType()) {
            model.setAddress("tt://perfectData");
            if (TASK_STATE_YES == model.getNewbiewTaskState()) {
                model.setCompleted(true);
            }
            return true;
        }

        //首次发帖
        if (TASK_FIRST_POST_INTIVATION.getType() == model.getTaskType()) {
            model.setAddress("tt://postInvitation");
            if (TASK_STATE_YES == model.getNewbiewTaskState() || !isPost) {
                model.setCompleted(true);
            }
            return true;
        }

        //收藏任务判断
        if (TASK_COLLECT_APPLET_MINI.getType() == model.getTaskType()) {
            NoviceTaskRecord noviceTaskRecord =
                    noviceTaskRecordMapper.findSelectiveByTaskType(model.getTaskType(), userId);

            if (null != noviceTaskRecord && 1 == noviceTaskRecord.getState()) {
                model.setCompleted(true);
                return true;
            }
            logger.debug("收藏任务没记录或者未完成,任务记录为:{}", JSON.toJSONString(noviceTaskRecord));
            return true;
        }


        //增加关注微信公众号以及判断
        if (TaskEnum.TASK_FOCUS_WECAHT.getType() == model.getTaskType()) {
            UserAuth userAuth = userAuthIntegrationService.selectWechatUserAuthByUserId(userId);
            if (null != userAuth) {
                if (wxMpFacadeService.subscribeWechat(userAuth.getIdentifier())) {
                    //若查询到已关注公众号但无任务完成记录，则触发完成任务功能-（前端无法触发关注公众号任务完成）
                    NoviceTaskRecord noviceTaskRecord = noviceTaskRecordMapper.findSelectiveByTaskType(
                            TaskEnum.TASK_FOCUS_WECAHT.getType(), userId);
                    if (noviceTaskRecord == null) {
                        logger.info("当前用户[{}]关注公众号----触发任务完成", userId);
                        completeTask(userId, TaskEnum.TASK_FOCUS_WECAHT, null,null);
                    }
                    model.setCompleted(true);
                }
            }

        }

        return true;
    }


    /**
     * 处理日常任务
     *
     * @param userMissionModel  用户任务类
     * @param userId            用户id
     * @param locationFacadeDTO location传输对象
     * @param isPost            是否post
     * @param dailyTaskMap      日常任务map
     */
    private void processDailyTask(UserMissionModel userMissionModel, TaskEnum taskEnum, Long userId,
                                  boolean isPost, Map<String, Byte> dailyTaskMap, LocationFacadeDTO locationFacadeDTO) {


        userMissionModel.setState(dailyTaskMap.get(userMissionModel.getId().toString()) == null ? TASK_STATE_NO : TASK_STATE_YES);
        //根据类型获取具体任务枚举类
        KeyGenerator key = null;
        switch (taskEnum) {
            case TASK_NEWS_READ:
                key = NEWS_READ.copy().setKey(userId + DateUtils.PATTERN_NO_DELIMITER_FORMAT.get().format(new Date()));
                userMissionModel.setAddress("tt://readNews");
                break;
            case TASK_NEWS_SHARE:
                key = TASK_SHARE_NEWS_NUM.copy().appendKey(userId.toString()).appendKey(DateUtils.formatDate(new Date()));
                userMissionModel.setAddress("tt://shareWxchat");
                break;
            case TASK_VIDEO_READ:
                key = VIDEO_READ_NUM.copy().appendKey(userId + DateUtils.PATTERN_NO_DELIMITER_FORMAT.get().format(new Date()));
                userMissionModel.setAddress("tt://lookVideo");
                break;
            case TASK_INVITED_FRIEND:
                userMissionModel.setCompleted(false);
                userMissionModel.setAddress("tt://inviteSt");
                break;
            case TASK_ACTIVATION_VIP:
                Boolean isVip = checkVipAcvation(userId, locationFacadeDTO);
                userMissionModel.setCompleted(isVip);
                userMissionModel.setAddress("tt://callActivateVip");
                break;
            case TASK_POST_INTIVATION:
                userMissionModel.setCompleted(isPost);
                key = POST_FORUM.copy().appendKey(userId + DateUtils.PATTERN_NO_DELIMITER_FORMAT.get().format(new Date()));
                userMissionModel.setAddress("tt://postInvitation");
                break;

            case TASK_FISRT_BROWSE:
                userMissionModel.setAddress("tt://shareNews");
                //替换本地为当地名称
                userMissionModel.setName(userMissionModel.getName().replace("本地", locationFacadeDTO.getName()).replace("市", "").replace("县", ""));
                break;
            case TASK_COMMENT_NEWS:
                userMissionModel.setAddress("tt://commentNews");
                //替换本地为当地名称
                userMissionModel.setName(userMissionModel.getName().replace("本地", locationFacadeDTO.getName()).replace("市", "").replace("县", ""));
                key = NEWS_COMMENT.copy().appendKey(userId + DateUtils.PATTERN_NO_DELIMITER_FORMAT.get().format(new Date()));
                break;
            default:
                break;
        }
        if (key != null) {
            Integer number;
            if (redisStringAdapter.hasKey(key)) {
                number = this.redisStringAdapter.getInt(key);
            } else {
                number = 0;
            }
            userMissionModel.setCompleted(number >= userMissionModel.getNumber());
            userMissionModel.setCompletedNum(number);
            userMissionModel.setTotalNum(userMissionModel.getNumber());
        }

    }


    private Long completeTaskForFirstBrower(Long userId, String relationId, TaskEnum taskEnum) {

        if (userId.equals(Long.valueOf(relationId))) {
            return 0L;
        }
        String browseUserType = "OLD_USER";
        User user = userIntegrationService.selectByPrimaryKey(Long.valueOf(relationId));
        if (user == null) {
            logger.info("浏览人[{}]不存在", relationId);
            return 0L;
        }

        //老用户奖励3朵小红花
        Long reward = 0L;
        //relationId是否是新用户
        //生成20到50朵小火花
        if (StringUtils.isEmpty(user.getWeixin())) {
            browseUserType = "NEW_USER";
            reward = RandomUtils.nextLong(20, 50);
        } else {
            reward = 3L;
        }

        Byte isAward = 0;

        Date browseTime = DateUtils.parse(DateUtils.formatAtWill(new Date(), DateUtils.DATE_FORMAT));
        BrowseRecord browseRecord = browseRecordMapper.selectBrowseRecord(Long.valueOf(relationId), browseTime, (byte) 1);
        Long recordId = nextId();
        if (browseRecord == null) {
            logger.debug("浏览人[{}]今天还未浏览任何用户的分享内容----给分享人[{}]添加金币[{}]", relationId, userId, reward);

            logger.debug("添加用户[{}]账户的金币和流水,金币[{}], 建立关系的id：[{}]", userId, reward, recordId);
            AccountGoldParam param = new AccountGoldParam(userId, "USABLE_GOLD", true,
                    reward.intValue(), recordId,
                    taskEnum.name());
            addUserGold(param);
            isAward = 1;
        }
        BrowseRecord br = new BrowseRecord(recordId, userId, Long.valueOf(relationId), null,
                browseTime, browseUserType, isAward, reward.intValue());
        browseRecordMapper.insert(br);
        if (isAward == 0) {
            return 0L;
        }
        return reward;

    }


    /**
     * 判断是否完成新人任务
     *
     * @param userId
     * @param taskEnum
     * @return
     */
    private boolean isCompleteNoviceTask(Long userId, TaskEnum taskEnum) {
        NoviceTaskRecord noviceTaskRecord = noviceTaskRecordMapper.findSelectiveByTaskType(taskEnum.getType(), userId);
        if (null != noviceTaskRecord && NoviceTaskRecord.FINISHED == noviceTaskRecord.getState()) {
            logger.debug("查询的新人任务已完成,用户id:{},任务类型:{}", userId, taskEnum.getDesc());
            return true;
        }

        logger.debug("查询新人任务未完成,用户id:{},任务类型:{}", userId, taskEnum.getDesc());
        return false;

    }

    /**
     * 过滤不对外展示的任务(新手)
     *
     * @param model 任务信息类
     * @return 符合过滤(需要过滤的 - 即为不展示的任务)返回true, 否则返回false
     */
    private boolean filterNotDisplayTaskByNoviceTask(UserMissionModel model) {
        return TaskEnum.TASK_FIRST_LOGIN.getType() == model.getTaskType();
    }
}
