package com.bxm.localnews.activity.service.impl;

import javax.annotation.Resource;

import com.bxm.localnews.activity.domain.PrivilegeMapper;
import com.bxm.localnews.activity.domain.PrivilegeParticipantMapper;
import com.bxm.localnews.activity.service.PrivilegeParticipantService;
import com.bxm.localnews.activity.vo.PrivilegeParticipantVO;
import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisZSetAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;

import org.springframework.stereotype.Service;

/**
 * Created by Arei on 2018/10/22.
 */
@Service("privilegeParticipantService")
public class PrivilegeParticipantServiceImpl implements PrivilegeParticipantService {

    @Resource
    private PrivilegeParticipantMapper privilegeParticipantMapper;

    @Resource
    private SequenceCreater sequenceCreater;

    @Resource
    private RedisZSetAdapter redisZSetAdapter;

    @Resource
    private PrivilegeMapper privilegeMapper;

    @Resource
    private BizLogService bizLogService;

    @Override
    public PrivilegeParticipantVO getPrivilegeParticipant(Long userId, Long privilegeId) {
        return privilegeParticipantMapper.getPrivilegeParticipant(userId, privilegeId);
    }

    @Override
    public int saveParticipantPrivilege(Long userId,
                                        Long inviteUserId,
                                        Long privilegeId,
                                        String ip) {
        PrivilegeParticipantVO privilegeParticipantVO = new PrivilegeParticipantVO();
        privilegeParticipantVO.setId(sequenceCreater.nextLongId());

        //验证只有参加过活动的用户才能作为邀请人，否则不记录邀请关系，用户参加活动仍然成功
        if (this.getPrivilegeParticipant(inviteUserId, privilegeId) != null) {
            bizLogService.invitePrivilege(inviteUserId, userId, privilegeId);
            privilegeParticipantVO.setInviteUserId(inviteUserId);
        }

        privilegeParticipantVO.setIp(ip);
        privilegeParticipantVO.setUserId(userId);
        privilegeParticipantVO.setPrivilegeId(privilegeId);

        int saveResult = privilegeParticipantMapper.savePrivilegeParticipant(privilegeParticipantVO);

        privilegeMapper.updatePrivilegeParticipantNum(privilegeId);
        //记录邀请排行榜，只有在邀请人不为空时记录
        if (privilegeParticipantVO.getInviteUserId() != null) {
            KeyGenerator inviteNumRedisKey = RedisConfig.PRIVILEGE_INVITENUM.copy().appendKey(privilegeId);
            redisZSetAdapter.incrementScore(inviteNumRedisKey, inviteUserId, 1d);
        }

        bizLogService.joinPrivilege(userId, privilegeId);
        return saveResult;
    }

}
