package com.bxm.localnews.activity.service.redpacket.command;

import com.bxm.localnews.activity.dto.CommandResultDTO;
import com.bxm.localnews.activity.dto.ScoreDto;
import com.bxm.localnews.activity.dto.SubtractDTO;
import com.bxm.localnews.activity.vo.RedPacket;
import com.bxm.localnews.vo.User;

/**
 * 领红包
 * @ClassName RedPacketObtainService
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author zhaox
 * @Date 2019/4/30 15:30
 * @Version 1.0.0
 * @Modifier zhaox
 * @Modify Date 2019/4/30 15:30
 **/
public interface RedPacketObtainService {

    /**
     * 领取红包
     * @param rpId 红包id
     * @param scoreDto 打分实体
     * @param user 领红包用户
     * @param retryTime 重试次数
     * @return
     */
    CommandResultDTO obtainRedPacket(Long rpId, ScoreDto scoreDto, User user,Integer platform, Integer retryTime);

    /**
     * 领取红包（站外）
     * @param rpId 红包id
     * @param packetType 红包类型
     * @param city 市名
     * @param district 区县名
     * @param scoreDto 打分实体
     * @param user 用户实体
     * @param retryTime 重试次数
     * @return
     */
    CommandResultDTO publicObtainRedPacket(Long rpId,Integer packetType,String city,String district,ScoreDto scoreDto,User user,Integer platform,Integer retryTime);

    /**
     * 获取当地新人红包金额（站外）
     * @param city 市名
     * @param district 区县名
     * @param packetType 红包类型
     * @param user 用户
     * @return
     */
    String getNewUserRpAmount(String city,String district,Integer packetType,User user);
}
