package com.bxm.localnews.activity.service.redpacket.command.impl;

import com.bxm.localnews.activity.domain.RedPacketObtainFailedHistoryMapper;
import com.bxm.localnews.activity.service.redpacket.command.RedPacketObtainFailedHistoryService;
import com.bxm.localnews.activity.vo.RedPacketObtainFailedHistory;
import com.bxm.newidea.component.uuid.SequenceCreater;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @ClassName RedPacketObtainFailedHistoryServiceImpl
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author zhaox
 * @Date 2019/4/28 16:26
 * @Version 1.0.0
 * @Modifier zhaox
 * @Modify Date 2019/4/28 16:26
 **/
@Service
public class RedPacketObtainFailedHistoryServiceImpl implements RedPacketObtainFailedHistoryService {
    @Autowired
    private RedPacketObtainFailedHistoryMapper obtainFailedHistoryMapper;
    @Resource
    private SequenceCreater sequenceCreater;

    @Async
    @Override
    public void addOne(Long userId, Long rpId, String commandUrl, Integer score) {
        RedPacketObtainFailedHistory failedHistory = convertObtainFailedHistory(userId, rpId, commandUrl, score);
        obtainFailedHistoryMapper.addOne(failedHistory);
    }

    private RedPacketObtainFailedHistory convertObtainFailedHistory(Long userId, Long rpId, String commandUrl, Integer score) {
        RedPacketObtainFailedHistory redPacketObtainFailedHistory = new RedPacketObtainFailedHistory();
        redPacketObtainFailedHistory.setId(sequenceCreater.nextLongId());
        redPacketObtainFailedHistory.setRpId(rpId);
        redPacketObtainFailedHistory.setUserId(userId);
        redPacketObtainFailedHistory.setRecordUrl(commandUrl);
        redPacketObtainFailedHistory.setScore(score);
        return redPacketObtainFailedHistory;
    }
}
