/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.record.convert;

import com.bxm.localnews.activity.record.convert.IConverter;
import com.bxm.localnews.activity.record.utils.RecordUtils;
import com.bxm.localnews.activity.vo.RecordInfoBean;
import com.bxm.newidea.component.tools.FileUtils;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class ConvertProcesser
implements ApplicationContextAware,
InitializingBean {
    private ApplicationContext applicationContext;
    private Map<String, IConverter> converterMap = Maps.newHashMap();

    public RecordInfoBean convert(File sourceFile, int duration) {
        RecordInfoBean recordInfo = new RecordInfoBean();
        String fileExtend = FileUtils.getFileExtension((File)sourceFile);
        IConverter converter = this.converterMap.get(fileExtend);
        File afterFile = converter.convert(sourceFile);
        recordInfo.setConvertExtend(converter.after());
        recordInfo.setConvertFile(afterFile);
        recordInfo.setSourceFile(sourceFile);
        recordInfo.setDuration(this.getRecordDuration(afterFile, duration));
        return recordInfo;
    }

    private int getRecordDuration(File recordFile, int duration) {
        if (duration != -1) {
            return duration;
        }
        return RecordUtils.getDuration(recordFile);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        Map beanMap = this.applicationContext.getBeansOfType(IConverter.class);
        for (Map.Entry bean : beanMap.entrySet()) {
            this.converterMap.put(((IConverter)bean.getValue()).support(), (IConverter)bean.getValue());
        }
    }
}

