/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.record.convert.impl;

import com.bxm.localnews.activity.record.convert.IConverter;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.io.File;
import java.text.MessageFormat;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class Speex2WavConverter
implements IConverter {
    private static final Logger log = LoggerFactory.getLogger(Speex2WavConverter.class);
    private static final Logger logger = LoggerFactory.getLogger(Speex2WavConverter.class);
    private final BizConfigProperties bizConfigProperties;
    private final SequenceCreater sequenceCreater;
    private final AsyncTaskExecutor taskExecutor;

    @Autowired
    public Speex2WavConverter(BizConfigProperties bizConfigProperties, SequenceCreater sequenceCreater, AsyncTaskExecutor taskExecutor) {
        this.bizConfigProperties = bizConfigProperties;
        this.sequenceCreater = sequenceCreater;
        this.taskExecutor = taskExecutor;
    }

    @Override
    public String support() {
        return "speex";
    }

    @Override
    public String after() {
        return "wav";
    }

    @Override
    public File convert(File sourceFile) {
        Object body = null;
        String wavFilePath = this.bizConfigProperties.getTempDir() + this.sequenceCreater.nextStringId() + ".wav";
        File converFile = null;
        logger.info("source file length:[{}]", (Object)sourceFile.length());
        try {
            String command = MessageFormat.format("speex_decode {0} {1}", sourceFile.getPath(), wavFilePath);
            int n = this.execCommand(command);
            if (n == 0) {
                converFile = new File(wavFilePath);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return converFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execCommand(String command) {
        Process process = null;
        Future executeFuture = null;
        try {
            Process p = process = Runtime.getRuntime().exec(command);
            Callable<Integer> call = () -> {
                p.waitFor();
                return p.exitValue();
            };
            executeFuture = this.taskExecutor.submit(call);
            int n = (Integer)executeFuture.get(5000L, TimeUnit.MILLISECONDS);
            return n;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            int n = 1;
            return n;
        }
        finally {
            if (executeFuture != null) {
                try {
                    executeFuture.cancel(true);
                }
                catch (Exception exception) {}
            }
            if (process != null) {
                process.destroy();
            }
        }
    }
}

