/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.record.grade;

import com.bxm.localnews.activity.record.grade.GradeStrategy;
import com.bxm.localnews.activity.record.utils.RecordUtils;
import com.bxm.localnews.activity.vo.GradeResultBean;
import com.bxm.localnews.activity.vo.RecordGradeContext;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.PinyinUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
public class GradeProcesser
implements InitializingBean,
ApplicationContextAware {
    private Collection<GradeStrategy> strategies;
    private Map<Integer, String> targetMap = Maps.newConcurrentMap();
    private Map<Integer, String> targetPinyinMap = Maps.newConcurrentMap();
    private Pattern pattern = Pattern.compile("[^0-9]");
    private ApplicationContext applicationContext;

    public GradeResultBean grade(RecordGradeContext context) {
        GradeResultBean result = new GradeResultBean();
        context.setGrade(result);
        this.preProcess(context);
        for (GradeStrategy strategy : this.strategies) {
            strategy.grade(context);
        }
        result.setLength(context.getDuration());
        result.setOssUrl(context.getOssUrl());
        return result;
    }

    private void preProcess(RecordGradeContext context) {
        String target = context.getTarget();
        int targetHashCode = target.hashCode();
        String convertTarget = this.targetMap.get(targetHashCode);
        if (null == convertTarget) {
            convertTarget = this.convertNum(target);
            this.targetMap.put(targetHashCode, convertTarget);
            if (this.targetMap.size() > 500) {
                this.targetMap.clear();
            }
        }
        context.setConverTarget(convertTarget);
        String convertPinyinTarget = this.targetPinyinMap.get(targetHashCode);
        if (null == convertPinyinTarget) {
            convertPinyinTarget = StringUtils.join((Object[])PinyinUtils.getPinyinArray((String)convertTarget), (String)",");
            this.targetPinyinMap.put(targetHashCode, convertPinyinTarget);
        }
        context.setPinyinTarget(convertPinyinTarget);
        String result = this.replaceSpecialChar(context.getResult()).replace(" ", "");
        context.setResult(result);
        context.setPinyinResult(StringUtils.join((Object[])PinyinUtils.getPinyinArray((String)result), (String)","));
    }

    private String convertNum(String sourceStr) {
        String[] numStrArray;
        String convertContent = this.replaceSpecialChar(sourceStr);
        for (String numStr : numStrArray = this.pattern.matcher(convertContent).replaceAll(" ").split(" ")) {
            if (!StringUtils.isNotBlank((CharSequence)numStr)) continue;
            convertContent = convertContent.replaceFirst(numStr, RecordUtils.formatDecimal(NumberUtils.parseToLong((String)numStr)));
        }
        return convertContent.replace(" ", "");
    }

    private String replaceSpecialChar(String src) {
        String convertContent = src.replaceAll("[\\p{Punct}\\pP \u3000]", " ");
        convertContent = convertContent.replaceAll("\n", " ");
        return convertContent.replaceAll("\r", " ");
    }

    public void afterPropertiesSet() throws Exception {
        this.strategies = this.applicationContext.getBeansOfType(GradeStrategy.class).values();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

