/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.record.utils;

import it.sauronsoftware.jave.Encoder;
import it.sauronsoftware.jave.MultimediaInfo;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordUtils {
    private static final Logger log = LoggerFactory.getLogger(RecordUtils.class);
    static String[] units = new String[]{"", "\u5341", "\u767e", "\u5343", "\u4e07", "\u5341\u4e07", "\u767e\u4e07", "\u5343\u4e07", "\u4ebf", "\u5341\u4ebf", "\u767e\u4ebf", "\u5343\u4ebf", "\u4e07\u4ebf"};
    static char[] numArray = new char[]{'\u96f6', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'};

    private RecordUtils() {
    }

    public static int getDuration(File recordFile) {
        Encoder encoder = new Encoder();
        long ls = 0L;
        try {
            MultimediaInfo m = encoder.getInfo(recordFile);
            ls = m.getDuration() / 1000L;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5f55\u97f3\u65f6\u957f\u9519\u8bef\uff0c\u6587\u4ef6\u4e3a\uff1a" + recordFile, (Throwable)e);
        }
        return (int)ls;
    }

    public static String formatInteger(int num) {
        char[] val = String.valueOf(num).toCharArray();
        int len = val.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            String m = val[i] + "";
            int n = Integer.valueOf(m);
            boolean isZero = n == 0;
            String unit = units[len - 1 - i];
            if (isZero && '0' != val[i - 1]) {
                sb.append(numArray[n]);
                continue;
            }
            sb.append(numArray[n]);
            sb.append(unit);
        }
        return sb.toString();
    }

    public static String formatDecimal(double decimal) {
        String decimals = String.valueOf(decimal);
        int decIndex = decimals.indexOf(".");
        int integ = Integer.valueOf(decimals.substring(0, decIndex));
        int dec = Integer.valueOf(decimals.substring(decIndex + 1));
        String result = RecordUtils.formatInteger(integ);
        if (0 != dec) {
            result = result + "\u70b9" + RecordUtils.formatFractionalPart(dec);
        }
        return result;
    }

    private static String formatFractionalPart(int decimal) {
        char[] val = String.valueOf(decimal).toCharArray();
        int len = val.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int n = Integer.valueOf(val[i] + "");
            sb.append(numArray[n]);
        }
        return sb.toString();
    }
}

