/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.impl;

import com.bxm.localnews.activity.domain.LevelConfigMapper;
import com.bxm.localnews.activity.service.LevelConfigService;
import com.bxm.localnews.activity.vo.LevelConfig;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LevelConfigServiceImpl
implements LevelConfigService {
    private LevelConfigMapper levelConfigMapper;
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    public LevelConfigServiceImpl(LevelConfigMapper levelConfigMapper, RedisStringAdapter redisStringAdapter) {
        this.levelConfigMapper = levelConfigMapper;
        this.redisStringAdapter = redisStringAdapter;
    }

    public List<LevelConfig> getLevelConfigs() {
        TypeReference<List<LevelConfig>> typeReference = new TypeReference<List<LevelConfig>>(){};
        List result = (List)this.redisStringAdapter.get(RedisConfig.USER_LEVEL_CONFIG, (TypeReference)typeReference);
        if (CollectionUtils.isEmpty((Collection)result)) {
            result = this.levelConfigMapper.listAll();
            this.redisStringAdapter.set(RedisConfig.USER_LEVEL_CONFIG, (Object)result, 604800L);
        }
        return result;
    }

    public LevelConfig selectByPrimaryKey(Long id) {
        List<LevelConfig> levelConfigs = this.getLevelConfigs();
        for (LevelConfig config : levelConfigs) {
            if (null == id || !id.equals(config.getId())) continue;
            return config;
        }
        return null;
    }
}

