/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.activity.service.redpacket.command.impl;

import com.bxm.localnews.activity.constant.CashEnum;
import com.bxm.localnews.activity.constant.RedPacketAmountStatesEnum;
import com.bxm.localnews.activity.domain.RedPacketMapper;
import com.bxm.localnews.activity.domain.RedPacketObtainHistoryMapper;
import com.bxm.localnews.activity.dto.RedPacketObtainDOT;
import com.bxm.localnews.activity.dto.ScoreDto;
import com.bxm.localnews.activity.dto.SubtractDTO;
import com.bxm.localnews.activity.service.redpacket.command.RedPacketAmountService;
import com.bxm.localnews.activity.service.redpacket.command.RedPacketPushService;
import com.bxm.localnews.activity.util.AmountUtil;
import com.bxm.localnews.activity.vo.RedPacket;
import com.bxm.localnews.activity.vo.RedPacketObtainHistory;
import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.common.exception.BusinessException;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.param.AccountCashParam;
import com.bxm.localnews.vo.User;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RedPacketAmountServiceImpl
implements RedPacketAmountService {
    private static final Logger logger = LoggerFactory.getLogger(RedPacketAmountServiceImpl.class);
    @Autowired
    private RedPacketMapper redPacketMapper;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private RedPacketObtainHistoryMapper obtainHistoryMapper;
    @Autowired
    private UserAccountIntegrationService userAccountIntegrationService;
    @Autowired
    private BizLogService bizLogService;
    @Autowired
    private RedPacketPushService redPacketPushService;

    @Override
    @Transactional
    public SubtractDTO setSurplusAmount(RedPacket redPacket, ScoreDto scoreDto, User user, Integer platform) {
        BigDecimal rewardAmount = AmountUtil.calculateRewardAmount(redPacket.getAmount(), redPacket.getExpectNum(), scoreDto.getScore());
        RedPacketObtainDOT redPacketObtainDto = this.convertToRedPacketObtainDOT(redPacket, rewardAmount);
        Integer result = this.redPacketMapper.subtractSurplusAmount(redPacketObtainDto);
        if (result == 0) {
            return new SubtractDTO(Boolean.FALSE);
        }
        RedPacketObtainHistory redPacketObtainHistory = this.convertToRedPacketObtainHistory(redPacket, scoreDto, user, redPacketObtainDto.getActualAmount());
        result = this.obtainHistoryMapper.addOne(redPacketObtainHistory);
        if (result == 0) {
            throw new BusinessException("\u589e\u52a0\u7ea2\u5305\u83b7\u53d6\u8bb0\u5f55\u5931\u8d25");
        }
        Boolean addMoneyResult = this.addCash(user.getId(), redPacketObtainDto.getActualAmount());
        if (!addMoneyResult.booleanValue()) {
            throw new BusinessException("\u589e\u52a0\u53ef\u63d0\u73b0\u91d1\u989d\u5931\u8d25");
        }
        this.bizLogService.receiveRedPacket(user.getId(), redPacketObtainDto.getActualAmount(), platform);
        if (redPacketObtainDto.getSurplusAmount().compareTo(BigDecimal.ZERO) == 0) {
            logger.info("\u7ea2\u5305\u4f59\u989d\u4e3a0,\u63a8\u9001\u7ed9\u7528\u6237[{}],\u7ea2\u5305[{}]\u88ab\u9886\u5b8c", (Object)redPacket.getUserId(), (Object)redPacket.getId());
            this.redPacketPushService.pushRunOutMoney(redPacket.getUserId(), redPacket.getId());
        }
        return new SubtractDTO(Boolean.TRUE, redPacketObtainDto.getActualAmount());
    }

    private Boolean addCash(Long userId, BigDecimal scoreMoney) {
        AccountCashParam param = new AccountCashParam();
        param.setUserId(userId);
        param.setAddTotal(Boolean.valueOf(true));
        param.setCashType(CashEnum.DRAWABLEL_CASH.name());
        param.setCash(scoreMoney);
        param.setCashFlowType("COMMAND_RED_PACKET");
        return this.userAccountIntegrationService.addCash(param);
    }

    private RedPacketObtainHistory convertToRedPacketObtainHistory(RedPacket redPacket, ScoreDto scoreDto, User user, BigDecimal actualAmount) {
        RedPacketObtainHistory redPacketObtainHistory = new RedPacketObtainHistory();
        redPacketObtainHistory.setId(this.sequenceCreater.nextLongId());
        redPacketObtainHistory.setOwnerUserName(redPacket.getUserName());
        redPacketObtainHistory.setRpId(redPacket.getId());
        redPacketObtainHistory.setUserId(user.getId());
        redPacketObtainHistory.setUserName(user.getNickname());
        redPacketObtainHistory.setUserImg(user.getHeadImg());
        redPacketObtainHistory.setRecordUrl(scoreDto.getCommandUrl());
        redPacketObtainHistory.setRecordLength(scoreDto.getLength());
        redPacketObtainHistory.setObtainAmount(actualAmount);
        redPacketObtainHistory.setScore(scoreDto.getScore());
        return redPacketObtainHistory;
    }

    private RedPacketObtainDOT convertToRedPacketObtainDOT(RedPacket redPacket, BigDecimal scoreMoney) {
        RedPacketObtainDOT redPacketObtainDto = new RedPacketObtainDOT();
        redPacketObtainDto.setId(redPacket.getId());
        redPacketObtainDto.setOldVersion(redPacket.getVersion());
        redPacketObtainDto.setActualNum(Integer.valueOf(redPacket.getActualNum() + 1));
        redPacketObtainDto.setObtainStatus(redPacket.getObtainStatus());
        BigDecimal oldSurplusAmount = redPacket.getSurplusAmount();
        if (oldSurplusAmount.compareTo(scoreMoney) > 0) {
            redPacketObtainDto.setSurplusAmount(oldSurplusAmount.subtract(scoreMoney));
        } else {
            scoreMoney = redPacket.getSurplusAmount();
            redPacketObtainDto.setSurplusAmount(new BigDecimal(0));
            redPacketObtainDto.setObtainStatus(RedPacketAmountStatesEnum.UNOBTAINABLE.getType());
        }
        redPacketObtainDto.setActualAmount(scoreMoney);
        redPacketObtainDto.setNewVersion(Integer.valueOf(redPacket.getVersion() + 1));
        return redPacketObtainDto;
    }
}

