package com.bxm.localnews.activity.command;

import com.alibaba.fastjson.JSONObject;
import com.bxm.newidea.component.vo.BaseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.LinkedList;
import java.util.List;

public class TaskInvoke extends BaseBean {

    private static final Logger logger = LoggerFactory.getLogger(TaskInvoke.class);

    private List<TaskCommand> taskCommandList = new LinkedList<>();

    /**
     * 设置命令入命令队列
     * @param taskCommand
     */
    public void setCommand(TaskCommand taskCommand){
        taskCommandList.add(taskCommand);
    }

    /**
     * 在命令队列上执行命令
     */
    public void execute(){
        taskCommandList.forEach(e->{
            logger.debug("执行命令:[{}]",e.toString());
            e.execute();
        });
    }
}
