package com.bxm.localnews.activity.record.download;

import java.io.File;

import com.bxm.component.httpclient.service.OKHttpService;
import com.bxm.localnews.activity.record.parser.impl.RecordParserImpl;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.thirdparty.service.WxMpFacadeService;
import com.bxm.newidea.component.uuid.SequenceCreater;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 微信多媒体文件下载
 *
 * @author liujia
 */
@Component
public class WeixinMediaDownload {

    private final static Logger logger = LoggerFactory.getLogger(WeixinMediaDownload.class);

    private String baseUrl = "https://api.weixin.qq.com/cgi-bin/media/get/jssdk?access_token=";

    private OKHttpService okHttpService;

    private BizConfigProperties bizConfigProperties;

    private SequenceCreater sequenceCreater;

    private WxMpFacadeService wxMpFacadeService;

    @Autowired
    public WeixinMediaDownload(OKHttpService okHttpService, BizConfigProperties bizConfigProperties,
                               SequenceCreater sequenceCreater, WxMpFacadeService wxMpFacadeService) {
        this.okHttpService = okHttpService;
        this.bizConfigProperties = bizConfigProperties;
        this.sequenceCreater = sequenceCreater;
        this.wxMpFacadeService = wxMpFacadeService;
    }

    /**
     * 从微信下载多媒体文件
     *
     * @param mediaId 多媒体文件ID
     * @return 下载后的临时存储文件
     */
    public File download(String mediaId) {
        String url = buildURL(mediaId);
        String filePath = bizConfigProperties.getTempDir() + sequenceCreater.nextStringId() + ".speex";
        logger.info("微信录音文件下载地址:[{}]",url);
        okHttpService.download(url, filePath);
        return new File(filePath);
    }

    /**
     * 构建远程请求微信服务器下载的链接地址
     *
     * @return 请求地址
     */
    private String buildURL(String mediaId) {
        return baseUrl + wxMpFacadeService.getAccessToken() + "&media_id=" + mediaId;
    }
}
