package com.bxm.localnews.activity.record.grade.impl;

import com.bxm.localnews.activity.vo.RecordGradeContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * 根据读取顺序进行匹配
 * @author liujia
 */
@Component
public class SequenceStrategy extends AbstractGradStrategy {
    @Override
    public void grade(RecordGradeContext context) {
        String target = context.getConverTarget();
        String result = context.getResult();

        float score = 0;
        if (StringUtils.isNotBlank(result)) {
            char[] chars = target.toCharArray();
            char[] resultArray = result.toCharArray();
            int length = chars.length < resultArray.length ? chars.length : resultArray.length;
            int total = chars.length;
            int count = 0;
            for (int i = 0; i < length; i++) {
                if (chars[i] == resultArray[i]) {
                    count++;
                }
            }
            score = (float) count * 100 / total;
        }

        context.getGrade().setSequenceScore(score);
    }
}
