package com.bxm.localnews.activity.record.parser;

import com.bxm.localnews.activity.vo.RecordInfoBean;

import java.io.File;

/**
 * 录音处理，对录音进行格式转换，调用第三方API将录音转换为中文
 * @author liujia
 */
public interface RecordParser {

    /**
     * 处理录音
     * @param url      录音文件路径（OSS文件），客户端上传时
     * @param duration 录音时长，小于0将会采用录音实际文件
     * @return 处理结果
     */
    RecordInfoBean parse(String url, int duration);

    /**
     * 处理录音
     * @param recordFile 录音存储文件,直接上传录音文件流
     * @param duration   录音时长，小于0将会采用录音实际文件
     * @return 处理结果
     */
    RecordInfoBean parse(File recordFile, int duration);

    /**
     * 处理微信
     * @param mediaId 微信远程录音多媒体文件ID（jssdk中为serviceid）
     * @return 处理结果
     */
    RecordInfoBean parse(String mediaId);
}
