package com.bxm.localnews.activity.service.impl;

import com.bxm.localnews.activity.domain.DailyTaskMapper;
import com.bxm.localnews.activity.domain.NoviceTaskRecordMapper;
import com.bxm.localnews.activity.service.NoviceTaskRecordService;
import com.bxm.localnews.activity.vo.DailyTask;
import com.bxm.localnews.activity.vo.NoviceTaskRecord;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by mars on 2018/3/5.
 */
@Service("noviceTaskRecordService")
public class NoviceTaskRecordServiceImpl implements NoviceTaskRecordService {

    private final static Logger log = LoggerFactory.getLogger(NoviceTaskRecordServiceImpl.class);

    @Resource
    private DailyTaskMapper dailyTaskMapper;

    @Resource
    private NoviceTaskRecordMapper noviceTaskRecordMapper;

    @Override
    public void batchAdd(long userId) {
        List<DailyTask> taskList = this.dailyTaskMapper.findSelectiveByType(DailyTask.NEWBIE_TASK);
        if (CollectionUtils.isNotEmpty(taskList)) {
            List<NoviceTaskRecord> recordList = new ArrayList<>();
            for (DailyTask task : taskList) {
                NoviceTaskRecord record = new NoviceTaskRecord();
                record.setTaskId(task.getId());
                record.setState(NoviceTaskRecord.UNFINISHED);
                record.setUserId(userId);
                recordList.add(record);
            }
            this.noviceTaskRecordMapper.batchAdd(recordList);
        }
    }

    @Override
    public boolean isTaskCompleted(Long userId, String taskName) {
        NoviceTaskRecord noviceTaskRecord = noviceTaskRecordMapper.findSelectiveByTaskName(taskName, userId);
        if (null == noviceTaskRecord) {
            return false;
        }
        
        return noviceTaskRecord.getState() == 1;
    }

}
