package com.bxm.localnews.activity.service.impl;

import java.util.List;

import com.bxm.localnews.activity.domain.SignConfigMapper;
import com.bxm.localnews.activity.service.SignConfigService;
import com.bxm.localnews.activity.vo.SignConfig;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.fasterxml.jackson.core.type.TypeReference;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/4/4 11:50
 * @desc
 */
@Service
public class SignConfigServiceImpl implements SignConfigService {

    @Autowired
    private SignConfigMapper signConfigMapper;

    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Override
    public List<SignConfig> allSignConfig() {
        TypeReference<List<SignConfig>> typeReference = new TypeReference<List<SignConfig>>() {

        };
        List<SignConfig> signConfigList = redisStringAdapter.get(getSignConfigKey(), typeReference);
        if (CollectionUtils.isEmpty(signConfigList)) {
            signConfigList = signConfigMapper.listAll();
            redisStringAdapter.set(getSignConfigKey(), signConfigList);
        }
        return signConfigList;
    }

    private KeyGenerator getSignConfigKey() {
        return RedisConfig.SIGN_CONFIG_KEY.copy().appendKey("list");
    }
}
