package com.bxm.localnews.activity.service.redpacket.command;

import com.bxm.localnews.activity.vo.GradeResultBean;

import java.io.File;

/**
 * 录音评分服务接口
 * @author liujia
 */
public interface RecordGradeService {

    /**
     * 根据OSS中的地址下载录音，进行评分
     * @param target   目标内容（口令）
     * @param url      OSS录音文件的地址
     * @param duration 客户端提供的录音时长，如果为-1，将会根据录音文件进行计算
     * @return 评分结果
     */
    GradeResultBean getByUrl(String target, String url, int duration);

    /**
     * 使用指定的录音文件进行评分
     * @param target     目标内容（口令）
     * @param recordFile 录音文件
     * @param duration   客户端提供的录音时长，如果为-1，将会根据录音文件进行计算
     * @return 评分结果
     */
    GradeResultBean getByLocal(String target, File recordFile, int duration);

    /**
     * 获取微信媒体文件（录音文件）进行评分
     * @param target  目标内容（口令）
     * @param mediaId 微信服务端缓存的录音文件ID（jssdk上传的serviceId）
     * @return 评分结果
     */
    GradeResultBean getByWx(String target, String mediaId);
}
