package com.bxm.localnews.activity.service.redpacket.command.impl;

import com.bxm.localnews.activity.dto.ScoreDto;
import com.bxm.localnews.activity.service.redpacket.command.CommandGradeService;
import com.bxm.localnews.activity.service.redpacket.command.RecordGradeService;
import com.bxm.localnews.activity.common.utils.AmountUtil;
import com.bxm.localnews.activity.vo.GradeResultBean;
import com.bxm.localnews.common.exception.BusinessException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.File;
import java.math.BigDecimal;

/**
 * @ClassName CommandGradeServiceImpl
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author zhaox
 * @Date 2019/4/30 16:14
 * @Version 1.0.0
 * @Modifier zhaox
 * @Modify Date 2019/4/30 16:14
 **/
@Service
public class CommandGradeServiceImpl implements CommandGradeService {
    private final static Logger logger = LoggerFactory.getLogger(CommandGradeServiceImpl.class);
    @Autowired
    private RecordGradeService recordGradeService;

    @Override
    public ScoreDto grade(String target, String commandUrl, Integer length) {
        if (null == length) {
            length = -1;
        }
        // 评分
        GradeResultBean bean = recordGradeService.getByUrl(target, commandUrl, length);
        if (bean == null) {
            throw new BusinessException("口令评分异常");
        }

        return convertToScoreDto(bean, commandUrl, length);
    }

    @Override
    public ScoreDto grade(String target, String mediaId) {
        // 评分
        GradeResultBean bean = recordGradeService.getByWx(target, mediaId);

        if (bean == null) {
            throw new BusinessException("口令评分异常");
        }

        return convertToScoreDto(bean, null, -1);
    }

    @Override
    public GradeResultBean testRecord(String content, String path, Integer len) {
        if (StringUtils.isBlank(content) || StringUtils.isBlank(path)) {
            logger.warn("参数有误，content:{},path:{}", content, path);
            return null;
        }
        File file = new File(path);
        return recordGradeService.getByLocal(content, file, null == len ? -1 : len);
    }

    private ScoreDto convertToScoreDto(GradeResultBean bean, String commandUrl, Integer length) {

        Integer score = AmountUtil.halfUptIntValue(new BigDecimal(bean.calCompositeScore()));
        Integer matchScale = AmountUtil.halfUptIntValue(new BigDecimal(bean.getMatchScore()));
        String userScale = "0%";
        if (score > 40) {
            userScale = AmountUtil.halfUptStringValue(new BigDecimal(Math.ceil(70.0 + 29.0 * Math.sqrt((score - 40.0) / 60.0)))) + "%"; // 赞叹语百分值
        }
        Integer star = getStarByScore(score);// 星级
        if (commandUrl == null) {
            commandUrl = bean.getOssUrl();
        }
        if (length == -1) {
            length = bean.getLength();
        }
        return new ScoreDto(commandUrl, score, length, matchScale, userScale, star);
    }

    /**
     * 星级与评分的对应关系：
     * 40-59分：2星
     * 60-69分：3星
     * 70-89分：4星
     * 90+分：5星
     *
     * @param score 综合评分
     * @return
     */
    private Integer getStarByScore(Integer score) {
        if (score >= 40 && score <= 59) {
            return 2;
        } else if (score >= 60 && score <= 69) {
            return 3;
        } else if (score >= 70 && score <= 89) {
            return 4;
        } else if (score >= 90) {
            return 5;
        }
        return 0;
    }
}
