package com.bxm.localnews.activity.service.redpacket.command.impl;

import com.bxm.localnews.activity.service.redpacket.command.RedPacketPushService;
import com.bxm.localnews.integration.PushMsgIntegrationService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/**
 * @ClassName RedPacketPushServiceImpl
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author zhaox
 * @Date 2019/4/29 16:27
 * @Version 1.0.0
 * @Modifier zhaox
 * @Modify Date 2019/4/29 16:27
 **/
@Service
public class RedPacketPushServiceImpl implements RedPacketPushService {

    private final static Logger logger = LoggerFactory.getLogger(RedPacketPushServiceImpl.class);
    @Autowired
    private PushMsgIntegrationService pushMsgIntegrationService;

    @Async
    @Override
    public void pushRunOutMoney(Long userId, Long rpId) {
        String title = "\ud83d\udd25你的红包已经被领完啦，看看是谁领走了>";
        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.REA_PACKET_FINISH);
        info.addExtend("userId", userId);
        info.addExtend("rpId", rpId);

        PushMessage message = PushMessage.build();
        message.setTitle("通知消息");
        message.setContent(title);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
        message.setPayloadInfo(info);

        pushMsgIntegrationService.pushMsg((message));
        logger.info("推送给用户[{}]，红包[{}]已领完成功.",userId,rpId);
    }
}
