package com.bxm.localnews.activity.service.redpacket.command.impl;

import com.bxm.localnews.activity.common.constant.*;
import com.bxm.localnews.activity.domain.RedPacketObtainHistoryMapper;
import com.bxm.localnews.activity.dto.UserObtainRpStatesDTO;
import com.bxm.localnews.activity.service.redpacket.command.RedPacketStateService;
import com.bxm.localnews.activity.vo.RedPacket;
import com.bxm.localnews.activity.vo.RedPacketObtainHistory;
import com.bxm.localnews.common.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * @ClassName RedPackeStatusServiceImpl
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author zhaox
 * @Date 2019/4/30 15:42
 * @Version 1.0.0
 * @Modifier zhaox
 * @Modify Date 2019/4/30 15:42
 **/
@Service
public class RedPacketStateServiceImpl implements RedPacketStateService {
    @Autowired
    private RedPacketObtainHistoryMapper obtainHistoryMapper;

    @Override
    public RedPacketObtainStatesEnum rpStatesCheck(RedPacket redPacket, Long userId) {
        // 红包状态检查
        if (isObtainedByUser(redPacket.getId(), userId)) {
            return RedPacketObtainStatesEnum.OBTAINTED; // 已被用户领取
        }
        if (redPacket.getOnlineStatus().equals(OnlineStatesEnum.OFFLINE.getType())) {
            return RedPacketObtainStatesEnum.OFFLINE;// 已下线
        }
        if (redPacket.getObtainStatus().equals(RedPacketAmountStatesEnum.UNOBTAINABLE.getType())) {
            return RedPacketObtainStatesEnum.EMPTY;// 已领完
        }
        return null;
    }

    @Override
    public Boolean isObtainedByUser(Long rpId, Long userId) {
        Integer count = obtainHistoryMapper.countByUserAndRp(userId, rpId);
        if (count != 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public ObtainStatesEnum rpObtainStatus(BigDecimal amount, BigDecimal surplusAmount) {
        int result =surplusAmount.compareTo(BigDecimal.ZERO);
        if (result == 0) {
            // 红包余额为0
            return ObtainStatesEnum.OBTAINED;
        }

        result = amount.compareTo(surplusAmount);
        if (result == 0){
            // 红包总金额 = 红包余额 ，未领取
            return ObtainStatesEnum.NOTOBTAIN;
        }
        // 未领完
        return ObtainStatesEnum.PARTOBTAIN;
    }

    @Override
    public UserObtainRpStatesDTO userObtainRpStates(BigDecimal surplusAmount, Long userId, Long rpId) {
        RedPacketObtainHistory history = obtainHistoryMapper.queryByUserAndRp(userId, rpId); // 用户领取记录
        // 用户领取状态
        int result = surplusAmount.compareTo(BigDecimal.ZERO); // 剩余金额是否为0
        if (null == history && result == 1) {
            return new UserObtainRpStatesDTO(UserObtainRpStatesEnum.UNEMPTY_NOTGET);
        }
        if (null == history && result == 0) {
            return new UserObtainRpStatesDTO(UserObtainRpStatesEnum.EMPTY_NOTGET);
        }
        if (null != history) {
            return new UserObtainRpStatesDTO(UserObtainRpStatesEnum.GOT, history.getObtainAmount());
        }
        throw new BusinessException("user obtain redpacket states error,userId[" + userId + "],rpId[" + rpId + "]");
    }
}
