package com.bxm.localnews.activity.service.sign;

import com.bxm.localnews.activity.dto.sign.*;
import com.bxm.localnews.activity.param.sign.*;

import java.util.List;

/**
 * @author pf.w
 * @date 2020/10/26 14:14
 **/
public interface DailySignNewService {

    /**
     * 签到页基本信息
     *
     * @param signInfoParam 参数
     * @return 返回实体
     */
    DailySignDTO signInfo(SignInfoParam signInfoParam);

    /**
     * 签到日历
     * @param param 参数
     * @return 日历信息集合
     */
    List<SignRecordListDTO> listSignRecord(SignBasicParam param);

    /**
     * 签到
     *
     * @param param 签到参数
     * @return 签到返回实体
     */
    SignResultDTO doSign(SignBasicParam param);

    /**
     * 补签
     *
     * @param param 补签参数
     * @return 补签返回实体
     */
    SignResultDTO fillSign(FillSignParam param);

    /**
     * 今日签到状态信息
     *
     * @param signInfoParam 参数
     * @return 返回签到信息实体
     */
    SignTodayDTO signStatusToday(SignInfoParam signInfoParam);

    /**
     * 签到提醒操作
     * @param param 开关参数
     * @return true : 成功
     */
    Boolean signWarningOperate(SignWarningOperateParam param);

    /**
     * 签到礼包信息
     *
     * @param param 参数
     * @return 礼包信息实体
     */
    SignGiftInfoDTO signGiftInfo(SignBasicParam param);

    /**
     * 领取签到礼包
     *
     * @param param 参数
     * @return true : 成功
     */
    Boolean receiveGift(ReceiveGiftParam param);

    /**
     * 签到后看视频翻倍返回红花翻倍集合数据
     *
     * @param param 参数
     * @return 结果集
     */
    List<SignRewardChooseDTO> signAfterWatchVideoReward(SignRewardChooseParam param);
}
