package com.bxm.localnews.activity.service.sign;

import java.util.List;

import com.bxm.localnews.activity.dto.CalendarSignDTO;
import com.bxm.localnews.activity.dto.SignDTO;
import com.bxm.localnews.activity.dto.SignLeaderBoard;
import com.bxm.newidea.component.vo.Message;

/**
 * @author zhaoyadong 2019/4/4 10:50
 * @desc
 */
public interface DailySignService {

    /**
     * 获取用户签到记录
     *
     * @param userId
     * @return
     */
    SignDTO signRecord(Long userId,String areaCode);

    /**
     * 获取对应月份的签到列表
     *
     * @param userId
     * @return
     */
    List<CalendarSignDTO> listSignRecord(Long userId);

    /**
     * 用户签到
     *
     * @param userId
     * @return
     */
    Message executeUserSign(Long userId,String areaCode);

    /**
     * 用户补签
     *
     * @param userId
     * @return
     */
    Message executeUserFillSign(Long userId,String areaCode);

    /**
     * 用途：得到某个地区的签到排行榜
     * @return SignLeaderBoard
     */
    SignLeaderBoard getSignLeaderBoard(Long userId,String areaCode);
}
