package com.bxm.localnews.activity.service.sign.handle;

import com.bxm.localnews.activity.common.constant.sign.SignGiftTypeEnum;
import com.bxm.localnews.activity.domain.SignRecordMapper;
import com.bxm.localnews.activity.service.sign.DailySignNewCacheAndLogic;
import com.bxm.localnews.activity.vo.SignGiftReceiveContent;
import com.bxm.localnews.activity.vo.SignRecord;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;

/**
 *  领取签到礼包处理
 *
 *  （目前只有新人7天红包，可预见性有限，尽量做扩展；后续可根据具体需求调整）
 *
 * @author pf.w
 * @date 2020/10/26 19:47
 **/
public abstract class AbstractSignGiftPackageHandle {
    @Resource
    protected DailySignNewCacheAndLogic dailySignNewCacheAndLogic;

    @Resource
    private SignRecordMapper signRecordMapper;

    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    /**
     * 基础校验
     *
     * @param context 上下文
     * @return 校验结果
     */
    private Message preCheck(SignGiftContext context){
        if(Objects.isNull(context)){
            return Message.build(Boolean.FALSE).setMessage("不能为空");
        }

        if(Objects.isNull(context.getUserId())){
            return Message.build(Boolean.FALSE).setMessage("必要参数不能为空");
        }

        return Message.build(Boolean.TRUE);
    }

    /**
     *  内部校验
     * @param context 上下文
     * @return 校验结果
     */
    protected abstract Message check(SignGiftContext context);

    /**
     * 处理类
     * @param context 上线文
     * @return 处理结果
     */
    public final Message execute(SignGiftContext context){
        Message message = preCheck(context);
        if(!message.isSuccess()){
            return message;
        }
        message = check(context);
        if(!message.isSuccess()){
            return message;
        }
        message = logic(context);
        if(!message.isSuccess()){
            return message;
        }else{
            message = afterHandle(context);
        }
        return message;
    }

    /**
     * 具体处理逻辑
     *
     * @param context  上下文
     * @return 结果
     */
    protected abstract Message logic(SignGiftContext context);

    /**
     *  后置处理
     * @param context 上下文
     * @return 返回信息
     */
    protected abstract Message afterHandle(SignGiftContext context);

    /**
     *  类型
     * @return 类型
     */
    protected  abstract SignGiftTypeEnum suport();

    /**
     * 更新礼包领取集合 缓存
     *
     * @param userId  用户ID
     * @param typeEnum {@link SignGiftTypeEnum}
     * @return true : 成功
     */
    protected boolean saveUserGiftToRedis(Long userId, SignGiftTypeEnum typeEnum){
        //领取过的礼包集合
        List<SignGiftReceiveContent> hasReceiveList =  dailySignNewCacheAndLogic.userGiftList(userId);

        //用户签到信息
        SignRecord signRecord = signRecordMapper.getLastSignRecord(userId);
        if(Objects.isNull(signRecord)){
            return false;
        }

        SignGiftReceiveContent content = new SignGiftReceiveContent();
        content.setSignDay(signRecord.getSignDay());
        content.setGiftType(typeEnum.getType());
        content.setGift(typeEnum);

        if(CollectionUtils.isEmpty(hasReceiveList)){
            hasReceiveList = Lists.newArrayList();
        }
        hasReceiveList.add(content);

        //更新领取过的礼包缓存
        redisHashMapAdapter.put(dailySignNewCacheAndLogic.signUserGiftKey(),userId.toString(),hasReceiveList);
        return  true;

    }

}
