package com.bxm.localnews.activity.service.sign.handle;

import com.bxm.localnews.activity.common.constant.sign.SignGiftTypeEnum;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 连续签到领取新人礼包处理类
 *
 * （目前只有新人7天红包，可预见性有限，尽量做扩展；后续可根据具体需求调整）
 *
 * @author pf.w
 * @date 2020/10/26 19:49
 **/
@Component
public class SignGiftHandleManage {

    private Map<SignGiftTypeEnum,AbstractSignGiftPackageHandle> mappers;

    @Autowired
    public SignGiftHandleManage(List<AbstractSignGiftPackageHandle> handles){
        mappers = Maps.newHashMap();
        handles.forEach(processor-> mappers.put(processor.suport(),processor));
    }

    /**
     *  执行
     * @param context 上下文
     * @return 执行结果
     */
    public Message excuter(SignGiftContext context){
        return mappers.get(context.getSignGiftTypeEnum()).execute(context);
    }


}
