package com.bxm.localnews.activity.service.sign.handle.processor;

import com.bxm.localnews.activity.common.constant.sign.SignGiftEnum;
import com.bxm.localnews.activity.common.constant.sign.SignGiftTypeEnum;
import com.bxm.localnews.activity.service.sign.handle.AbstractSignGiftPackageHandle;
import com.bxm.localnews.activity.service.sign.handle.SignGiftContext;
import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 礼包为奖励红花
 *
 * @author pf.w
 * @date 2020/10/27 16:59
 **/
@Component
@Slf4j
public class SignGiftGoldTypeProcessor extends AbstractSignGiftPackageHandle {
    @Resource
    private UserAccountIntegrationService userAccountIntegrationService;

    @Resource
    private BizLogService bizLogService;

    @Override
    protected Message check(SignGiftContext context) {
        if(!dailySignNewCacheAndLogic.canReceiveGift(context.getUserId(),
                SignGiftEnum.getGiftEnum(context.getSignGiftTypeEnum().getType()))){
            return Message.build(Boolean.FALSE).setMessage("不符合条件，不能领取！");
        }
        return Message.build(Boolean.TRUE);
    }

    @Override
    protected Message logic(SignGiftContext context) {
        try {
            //记录 领取礼包
            super.saveUserGiftToRedis(context.getUserId(),SignGiftTypeEnum.SEVEN_DAY_NEW_USER_GOLD_SIGN_GIFT);

            //签到添加金币（红花）
            AccountGoldParam param = new AccountGoldParam(context.getUserId(),
                    "USABLE_GOLD",
                    true,
                    dailySignNewCacheAndLogic.goldNumTodayRandom(context.getUserId()).intValue(),
                    null,
                    "SIGN_GIFT_GOLD",
                    "签到礼包");

            userAccountIntegrationService.addGold(param);
        }catch (Exception e){
            log.error("增加礼包金币异常 error : {}",e);
        }

        return Message.build(Boolean.TRUE);
    }
    @Override
    protected Message afterHandle(SignGiftContext context) {
        //删除 礼包随机红花数缓存
        dailySignNewCacheAndLogic.removeGoldNumTodayRandom(context.getUserId());

        // 埋点
        PointReportParam reportParam = PointReportParam
                .build(context)
                .e("3034")
                .ev("132.2")
                .put("uid", context.getUserId().toString())
                .put("a",context.getAreaCode());
        bizLogService.report(reportParam);

        return Message.build(Boolean.TRUE);
    }

    @Override
    protected SignGiftTypeEnum suport() {
        return SignGiftTypeEnum.SEVEN_DAY_NEW_USER_GOLD_SIGN_GIFT;
    }
}
