package com.bxm.localnews.activity.service.sign.handle.processor;

import com.bxm.localnews.activity.common.constant.sign.SignGiftEnum;
import com.bxm.localnews.activity.common.constant.sign.SignGiftTypeEnum;
import com.bxm.localnews.activity.service.sign.handle.AbstractSignGiftPackageHandle;
import com.bxm.localnews.activity.service.sign.handle.SignGiftContext;
import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.integration.UserVipIntegrationService;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;

import javax.annotation.Resource;

/**
 * 礼包为开通vip
 *
 * @author pf.w
 * @date 2020/10/27 16:46
 **/
@Component
public class SignGiftVipTypeProcessor extends AbstractSignGiftPackageHandle {

    @Autowired
    private UserVipIntegrationService userVipIntegrationService;

    @Resource
    private BizLogService bizLogService;

    @Override
    protected Message check(SignGiftContext context) {
        if(!dailySignNewCacheAndLogic.hasVipForAreaCode(context.getAreaCode())){
            return Message.build(Boolean.FALSE).setMessage("不符合条件，不能领取！");
        }

        if(!dailySignNewCacheAndLogic.canReceiveGift(context.getUserId(),
                SignGiftEnum.getGiftEnum(context.getSignGiftTypeEnum().getType()))){
            return Message.build(Boolean.FALSE).setMessage("不符合条件，不能领取！");
        }
        return Message.build(Boolean.TRUE);
    }

    @Override
    protected Message logic(SignGiftContext context) {

        //记录 领取礼包
       super.saveUserGiftToRedis(context.getUserId(),SignGiftTypeEnum.SEVEN_DAY_NEW_USER_VIP_SIGN_GIFT);

        //开通vip
        return Message.build(userVipIntegrationService.openVipForSignGift(context.getUserId()));
    }

    @Override
    protected Message afterHandle(SignGiftContext context) {
        // 埋点
        PointReportParam reportParam = PointReportParam
                .build(context)
                .e("3034")
                .ev("132.1")
                .put("uid", context.getUserId().toString())
                .put("a",context.getAreaCode());
        bizLogService.report(reportParam);

        return Message.build(Boolean.TRUE);
    }

    @Override
    protected SignGiftTypeEnum suport() {
        return SignGiftTypeEnum.SEVEN_DAY_NEW_USER_VIP_SIGN_GIFT;
    }
}
