package com.bxm.localnews.activity.service.sign.impl;

import com.bxm.localnews.activity.common.config.AdvertProperties;
import com.bxm.localnews.activity.common.config.SignProperties;
import com.bxm.localnews.activity.common.constant.sign.SignGiftEnum;
import com.bxm.localnews.activity.common.constant.sign.SignGiftForNewUserEnum;
import com.bxm.localnews.activity.common.constant.sign.SignGiftTypeEnum;
import com.bxm.localnews.activity.common.constant.sign.SignWarningOperateEnum;
import com.bxm.localnews.activity.domain.SignRecordMapper;
import com.bxm.localnews.activity.dto.SignDTO;
import com.bxm.localnews.activity.dto.SignLeaderBoard;
import com.bxm.localnews.activity.dto.sign.*;
import com.bxm.localnews.activity.param.sign.*;
import com.bxm.localnews.activity.service.sign.DailySignNewCacheAndLogic;
import com.bxm.localnews.activity.service.sign.DailySignNewService;
import com.bxm.localnews.activity.service.sign.handle.SignGiftContext;
import com.bxm.localnews.activity.service.sign.handle.SignGiftHandleManage;
import com.bxm.localnews.activity.vo.SignRecord;
import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.dto.LotteryDetailFacadeDTO;
import com.bxm.localnews.integration.MerchantIntegrationService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisZSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.*;

import static com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils.join;

/**
 * @author pf.w
 * @date 2020/10/26 14:15
 **/
@Service
@Slf4j
@AllArgsConstructor
public class DailySignNewServiceImpl  implements DailySignNewService {

    private final DailySignNewCacheAndLogic dailySignNewCacheAndLogic;

    private final UserIntegrationService userIntegrationService;

    private final SignGiftHandleManage signGiftHandleManage;

    private final UserAccountIntegrationService userAccountIntegrationService;

    private final DailySignServiceImpl dailySignService;

    private final SignRecordMapper signRecordMapper;

    private final RedisZSetAdapter redisZSetAdapter;

    private final SignProperties signProperties;

    private final RedisHashMapAdapter redisHashMapAdapter;

    private final BaseUrlFacadeService baseUrlFacadeService;

    private final MerchantIntegrationService merchantIntegrationService;

    private final AdvertProperties advertProperties;

    @Resource
    private final BizLogService bizLogService;
    /**
     * 日历默认展示天数
     */
    private static final int SIGN_DEFATUL_DAYS = 7;

    /**
     * 签到后看视频得翻倍红花的边界值-MIN  (可以放到外部，但根据原来的签到逻辑看没必要，不必热更)
     */
    private static final int SIGN_AFTER_WATCH_VIDE_REWARD_MIN = 30;

    /**
     * 签到后看视频得翻倍红花的边界值-MAX
     */
    private static final int SIGN_AFTER_WATCH_VIDE_REWARD_MAX = 60;

    /**
     * 签到后看视频翻倍最大倍数
     */
    private static final int SIGN_AFTER_WATCH_VIDE_MAX_MULTIPEL = 10;

    @Override
    public DailySignDTO signInfo(SignInfoParam param) {
        DailySignDTO result = new DailySignDTO();
        //总金币数
        result.setTotalGold(BigDecimal.valueOf(userAccountIntegrationService.getUserUsableGold(param.getUserId())));

        LotteryDetailFacadeDTO ldfd = merchantIntegrationService.getLotteryInfo(param.getAreaCode());

        //该地区是否有夺宝活动
        result.setEnableSnatchTreasures(!Objects.isNull(ldfd));

        //活动跳链地址
        try {
            result.setSnatchTreasuresLinkUrl(result.getEnableSnatchTreasures()
                    ? baseUrlFacadeService.getInnerH5BaseUrl()+advertProperties.getFlowerGainTreasureUrl()
                    : join("wst://web/webDetail?isFlowerStore=1&url=",
                    URLEncoder.encode(baseUrlFacadeService.getServerHostBaseUrl()+advertProperties.getGoldWallUrl(),"UTF-8"))
                    );
        } catch (UnsupportedEncodingException e) {
            log.error("encode error : {}",e);
        }
        //活动文案
        result.setLinkText(result.getEnableSnatchTreasures() ? "去夺宝" : "兑好礼");
        SignDTO signDTO = dailySignService.signRecord(param.getUserId(),param.getAreaCode());

        //该地区是否开通签到排行
        result.setEnableSignBoard(signDTO.getEnableSignBoard() == 1);

        //签到跳链地址
        result.setSignBoardLinkUrl(baseUrlFacadeService.getInnerH5BaseUrl() + advertProperties.getSignRankUrl());
        //当前用户排名
        result.setRank(userSignBoardRank(param.getUserId(),param.getAreaCode()));

        //累计签到天数
        result.setCount(signDTO.getCount());

        //补签
        Integer countDays = signRecordMapper.countSignDayAll(param.getUserId());
        SignRecord signRecordLast = signRecordMapper.getLastSignRecord(param.getUserId());
        if(countDays<1){
            result.setYesterdaySignState(0);
        }else if(countDays == 1
                    && Objects.nonNull(signRecordLast)
                        && DateUtils.isSameDay(signRecordLast.getSignDate(),new Date())){
            result.setYesterdaySignState(0);
        }else{
            result.setYesterdaySignState(signDTO.isYesterdaySignState() ? 1 : 2);
        }

        //补签后可恢复连续签到天数  (分几种场景，自行看代码)
        result.setCountContinue(0L);
        if(signDTO.isYesterdaySignState()){
            //获取前天签到的信息
            SignRecord signRecord = signRecordMapper.getBeforeYesterDaySignRecord(param.getUserId());
            if(Objects.nonNull(signRecord)){
                result.setCountContinue(signDTO.isTodaySignState()
                        ? (long)(signRecord.getSignDay() + 2)
                        : (long)(signRecord.getSignDay() + 1));
            }else{
                result.setCountContinue(signDTO.isTodaySignState() ? 2L : 1L);
            }
        }

        //是否开通签到提醒
        result.setEnableOpenSignWarning(dailySignNewCacheAndLogic.isOpenSignWarning(param.getUserId()));
        //按钮文案
        result.setSignDayContinueForAward(7);

        //今日签到状态
        result.setTodaySignState(signDTO.isTodaySignState());
        //签到按钮文本
        result.setSignButtonSubtitle(dailySignNewCacheAndLogic.hasReceiveGiftInterest(param.getUserId(),
                SignGiftEnum.SIGN_GIFT_NEW_USER)
                ? "连续签到7天赢红包"  : null);

        result.setGoldNum(signDTO.getGold());

        result.setEnableReceive(dailySignNewCacheAndLogic.canReceiveGift(param.getUserId(),
                SignGiftEnum.SIGN_GIFT_NEW_USER));
        return result;
    }

    private Integer userSignBoardRank(Long userId,String areaCode){
        KeyGenerator signRecordKey = RedisConfig.SIGN_RANKING_KEY.copy().appendKey(areaCode);
        Set<SignLeaderBoard.LeaderBoard> leaderBoardSet =
                redisZSetAdapter.range(signRecordKey,
                        0,
                        signProperties.getRankSize()-1,
                        true,
                        SignLeaderBoard.LeaderBoard.class);

        int rank = 1;
        for (SignLeaderBoard.LeaderBoard e : leaderBoardSet) {
            if (Objects.equals(userId,e.getUserId())) {
                return rank;
            }
            rank ++;
        }
        return 0;
    }

    @Override
    public List<SignRecordListDTO> listSignRecord(SignBasicParam param) {
        if(log.isDebugEnabled()){
            log.debug("param : {}",param);
        }
        return signRecordList(param.getUserId());
    }

    @Override
    public SignResultDTO doSign(SignBasicParam param) {
        if(log.isDebugEnabled()){
            log.debug("param : {}",param);
        }
        //签到  调用原有逻辑
        Message message = dailySignService.executeUserSign(param.getUserId(),param.getAreaCode());

        if(message.isSuccess()){
            // 埋点
            PointReportParam reportParam = PointReportParam
                    .build(param)
                    .e("3034")
                    .ev("130")
                    .put("uid", param.getUserId().toString())
                    .put("a",param.getAreaCode());
            bizLogService.report(reportParam);
        }

        return signResultDTO(param.getUserId(),message);
    }

    @Override
    public SignResultDTO fillSign(FillSignParam param) {
        if(log.isDebugEnabled()){
            log.debug("param : {}",param);
        }
        //补签 调用原有逻辑
        Message message = dailySignService.executeUserFillSign(param.getUserId(),param.getAreaCode());

        return signResultDTO(param.getUserId(),message);
    }

    @Override
    public SignTodayDTO signStatusToday(SignInfoParam signInfoParam) {
        if(log.isDebugEnabled()){
            log.debug("param : {}",signInfoParam);
        }
        //获取签到相关信息
        SignDTO signDTO = dailySignService.generateSign(signInfoParam.getUserId());

        if(Objects.isNull(signDTO)){
            // 给个默认值
            return new SignTodayDTO(false,
                    dailySignService.getSignConfig(1).getReward().intValue());
        }

        return SignTodayDTO.builder()
                .enableSignToday(signDTO.isTodaySignState())
                .goldNum(signDTO.getGold())
                .build();
    }

    @Override
    public Boolean signWarningOperate(SignWarningOperateParam param) {
        if(log.isDebugEnabled()){
            log.debug("param : {}",param);
        }
        //开启
        if(Objects.equals(param.getOperate(),SignWarningOperateEnum.SIGN_WARNING_OPEN_OPERATE.getCode())){
            dailySignNewCacheAndLogic.openSignWarningToRedis(param.getUserId());

            // 埋点
            PointReportParam reportParam = PointReportParam
                    .build(param)
                    .e("3034")
                    .ev("131.1")
                    .put("uid", param.getUserId().toString())
                    .put("a",param.getAreaCode());


            bizLogService.report(reportParam);
            return true;
        }
        //关闭
        if(Objects.equals(param.getOperate(),SignWarningOperateEnum.SIGN_WARNING_CLOSED_OPERATE.getCode())){
            dailySignNewCacheAndLogic.closeSignWarningFromRedis(param.getUserId());

            // 埋点
            PointReportParam reportParam = PointReportParam
                    .build(param)
                    .e("3034")
                    .ev("131.0")
                    .put("uid", param.getUserId().toString())
                    .put("a",param.getAreaCode());
            bizLogService.report(reportParam);
            return true;
        }
        return false;
    }

    @Override
    public SignGiftInfoDTO signGiftInfo(SignBasicParam param) {
        if(log.isDebugEnabled()){
            log.debug("param : {}",param);
        }

        return SignGiftInfoDTO.builder()
                .enableReceive(dailySignNewCacheAndLogic.canReceiveGift(param.getUserId(),SignGiftEnum.SIGN_GIFT_NEW_USER))
                .signDayContinueForAward(7)
                .signGiftType(!userIntegrationService.checkUserIsVip(param.getUserId()) && dailySignNewCacheAndLogic.hasVipForAreaCode(param.getAreaCode())
                        ? SignGiftForNewUserEnum.GIFT_VIP.getCode()
                        : SignGiftForNewUserEnum.GIFT_GOLD.getCode())
                .signGiftGoldNum(dailySignNewCacheAndLogic.goldNumTodayRandom(param.getUserId()))
                .build();
    }

    @Override
    public Boolean receiveGift(ReceiveGiftParam param) {
        if(log.isDebugEnabled()){
            log.debug("param : {}",param);
        }

        SignGiftContext context = new SignGiftContext();
        context.setUserId(param.getUserId());
        context.setSignGiftTypeEnum(!userIntegrationService.checkUserIsVip(param.getUserId())
                && dailySignNewCacheAndLogic.hasVipForAreaCode(param.getAreaCode())
                        ? SignGiftTypeEnum.SEVEN_DAY_NEW_USER_VIP_SIGN_GIFT
                        : SignGiftTypeEnum.SEVEN_DAY_NEW_USER_GOLD_SIGN_GIFT);
        context.setAreaCode(param.getAreaCode());
        BeanUtils.copyProperties(param,context);

        //执行礼包领取
        Message message = signGiftHandleManage.excuter(context);
        return message.isSuccess();
    }

    @Override
    public List<SignRewardChooseDTO> signAfterWatchVideoReward(SignRewardChooseParam param) {
        if(log.isDebugEnabled()){
            log.debug("param : {}",param);
        }

        //判断今日是否已签到 未签到不能领
        SignDTO signDTO = dailySignService.generateSign(param.getUserId());
        if(!signDTO.isTodaySignState()){
            return Lists.newArrayList();
        }

        //组装翻倍红包结果集
        List<SignRewardChooseDTO> resultList = signRewardChooseList(param.getUserId(),param.getIndex());

        try{
            //签到添加金币
            AccountGoldParam accountGoldParam = new AccountGoldParam(
                     param.getUserId(),
                     "USABLE_GOLD",
                     true,
                     resultList.stream()
                             .filter(SignRewardChooseDTO::getSelected)
                             .findFirst()
                             .get()
                             .getGoldNum(),
                     null,
                     "SIGN_WATCH_VIDEO_MULTIPEL_GOLD","看视频"
            );
            userAccountIntegrationService.addGold(accountGoldParam);

            // 埋点
            PointReportParam reportParam = PointReportParam
                    .build(param)
                    .e("3034")
                    .ev("133")
                    .put("uid", param.getUserId().toString())
                    .put("a",param.getAreaCode());

            bizLogService.report(reportParam);
        }catch (Exception e){
            log.error("翻倍红包-服务调用异常 error : {}",e);
        }
        return resultList;
    }

    /**
     * 组装翻倍红包结果集 ---直接复制的原有的签到转发结果集逻辑
     *
     * @param userId 用户ID
     * @return 组装后的翻倍集合
     */
    private List<SignRewardChooseDTO> signRewardChooseList(Long userId,Integer index){
        //签到奖励
        int signReward =  signRecordMapper.getLastSignRecord(userId).getSignReward().intValue();
        //实际转发的奖励
        int reward = resultRewardForSignAfter(userId).intValue();
        int min = reward / 2;

        int other1;
        int other2;
        if (!redisHashMapAdapter.exists(RedisConfig.SIGN_WATCH_VIDEO_TIMES_KEY.copy(), String.valueOf(userId))) {
            other1 = RandomUtils.nextInt(min, reward);
            other2 = RandomUtils.nextInt(min, other1);
            redisHashMapAdapter.put(RedisConfig.SIGN_WATCH_VIDEO_TIMES_KEY.copy(),String.valueOf(userId),DateUtils.formatDate(new Date()));
        } else {
            other1 = RandomUtils.nextInt(min, reward);
            other2 = RandomUtils.nextInt(min, signReward * 10);
        }

        SignRewardChooseDTO rewardChoose1 = getRewardChoose(reward, signReward, true);
        SignRewardChooseDTO rewardChoose2 = getRewardChoose(other1, signReward, false);
        SignRewardChooseDTO rewardChoose3 = getRewardChoose(other2, signReward, false);

        List<SignRewardChooseDTO> rewardChooseSet = new ArrayList<>();
        rewardChooseSet.add(rewardChoose2);
        rewardChooseSet.add(rewardChoose3);
        rewardChooseSet.add(index<=3 ? index-1 : 3,rewardChoose1);
        return rewardChooseSet;
    }

    /**
     * 计算倍数，倍数=奖励数额/当日签到所得红花数，小于10时保留一位小数，不小于10时取整
     * ---复制原有的签到转发翻倍逻辑
     *
     * @param reward 实际数目
     * @param signReward 签到已得数目
     * @param isSelected 是否默认选中
     * @return 组装结果
     */
    private SignRewardChooseDTO getRewardChoose(int reward, int signReward, boolean isSelected) {
        BigDecimal rewardBig = BigDecimal.valueOf(reward);
        BigDecimal signRewardBig = BigDecimal.valueOf(signReward);
        float multiple;
        BigDecimal bigDecimal = rewardBig.divide(signRewardBig, 1, RoundingMode.HALF_UP);
        if (bigDecimal.compareTo(BigDecimal.TEN) >= 0) {
            multiple = bigDecimal.intValue();
        } else {
            multiple = bigDecimal.floatValue();
        }
        return new SignRewardChooseDTO(reward, multiple, isSelected);
    }

    /**
     * 签到真实的奖励数量
     *
     * （每次转发奖励控制在30~60朵红花，且不可大于当日签到所得红花数*10）---复制原有的签到转发翻倍逻辑
     *
     * @param userId 用户ID
     * @return 真是奖励数
     */
    private Long resultRewardForSignAfter(Long userId){
        //最大边界值
        int max = SIGN_AFTER_WATCH_VIDE_REWARD_MAX;
        //最小边界值
        int min = SIGN_AFTER_WATCH_VIDE_REWARD_MIN;
        //最大倍数10
        int multiple = SIGN_AFTER_WATCH_VIDE_MAX_MULTIPEL;
        SignRecord signRecord = signRecordMapper.getLastSignRecord(userId);
        if(Objects.isNull(signRecord)){
            return (long)min;
        }
        //如果是第一次转发签到则取最大值30-60，如果签到红花数*10大于60则取60
        if (!redisHashMapAdapter.exists(RedisConfig.SIGN_WATCH_VIDEO_TIMES_KEY.copy(), String.valueOf(userId))) {
            if (max >= signRecord.getSignReward() * multiple) {
                return signRecord.getSignReward() * multiple;
            } else {
                return (long)max;
            }
        } else {
            //如果是不是第一次转发签到则取30-60区间的数
            if (max >= signRecord.getSignReward() * multiple) {
                return (long)RandomUtils.nextInt(min, Math.toIntExact(signRecord.getSignReward() * multiple));
            } else {
                return (long)RandomUtils.nextInt(min, max);
            }
        }
    }

    private SignResultDTO signResultDTO(Long userId,Message message){
        SignResultDTO result = new SignResultDTO();
        result.setSign(false);
        if(message.isSuccess()){

            //获取最后一天签到的信息
            SignRecord signRecord = signRecordMapper.getLastSignRecord(userId);

            result.setSign(true);
            result.setGoldNum(dailySignService.getSignConfig(signRecord.getSignDay()).getReward());
            result.setTomorrowFlowers(dailySignService.getSignConfig(signRecord.getSignDay() + 1).getReward());
            result.setEnableGift(dailySignNewCacheAndLogic.canReceiveGift(userId,SignGiftEnum.SIGN_GIFT_NEW_USER));
        }
        return result;
    }

    /**
     * 组装签到日历内容
     *
     * @param userId 用户ID
     * @return 最终签到日历结果集
     */
    private List<SignRecordListDTO> signRecordList(Long userId){
        List<SignRecordListDTO> resultList = Lists.newArrayList();

        //循环外判断用户是否有领新人红包的权限（是否新人+是否领取过）
        Boolean hasGiftInterest = dailySignNewCacheAndLogic.hasReceiveGiftInterest(userId ,SignGiftEnum.SIGN_GIFT_NEW_USER);

        //获取用户的最后一条签到记录
        SignRecord signRecord = signRecordMapper.getLastSignRecord(userId);

        //组装连续签到对应的日常红花信息和礼包信息
        List<Date> dateList = makeSignDateList(userId);
        for(int i = 0 ;i < dateList.size();i++){
            SignRecordListDTO sr = new SignRecordListDTO();

            //填充签到礼包状态
            sr.setEnableGift(hasGiftInterest && Objects.nonNull(dailySignNewCacheAndLogic.getGiftPackage(i + 1)));

            //填充红花数，如果连续签到天数>7天 取7日红花数
            sr.setGoldNum(Objects.nonNull(signRecord) && signRecord.getSignDay() >= 7
                    ? dailySignService.getSignConfig(signRecord.getSignDay()).getReward()
                    : dailySignService.getSignConfig(i+1).getReward());

            sr.setDateSign(dateList.get(i));
            sr.setIsToday(false);

            if(DateUtils.isSameDay(new Date(),sr.getDateSign())){
                sr.setSignDate("今日");
                sr.setIsToday(true);
            }else{
                SimpleDateFormat sdf = new SimpleDateFormat("MM.d");
                sr.setSignDate(sdf.format(sr.getDateSign()));
            }
            resultList.add(sr);
        }

        //获取签到日历时间段内签到信息
        List<SignRecord> signRecords = signRecordMapper.getSignRecordForStartAndEndTime(userId,
                dateList.get(0),
                dateList.get(dateList.size()-1));

        //组装日历集合每日签到结果集
        resultList.forEach(result-> {
            result.setSignFlag(false);
            signRecords.forEach(record->{
                if(DateUtils.isSameDay(result.getDateSign(),record.getSignDate())){
                    result.setFill(record.getFillSign());
                    result.setSignFlag(true);
                }
            });
        });

        return resultList;
    }

    /**
     * 根据用户签到信息组装7日签到日历-只有日期
     *
     * @param userId 用户ID
     * @return 日历日和
     */
    private List<Date> makeSignDateList(Long userId){
        //获取今天的签到记录
        SignRecord signRecordToday = signRecordMapper.getTodaySignRecord(userId);
        //获取昨日的签到记录
        SignRecord signRecordYesterday = signRecordMapper.getYesterdaySignRecord(userId);

        if(Objects.nonNull(signRecordToday)){
            return dailySignNewCacheAndLogic.getDays(
                    days(signRecordToday.getSignDay(),
                             signRecordToday.getSignDate(),
                             false),
                    SIGN_DEFATUL_DAYS);
        }
        if(Objects.nonNull(signRecordYesterday)){
            return dailySignNewCacheAndLogic.getDays(days(signRecordYesterday.getSignDay()
                    ,signRecordYesterday.getSignDate(),true),SIGN_DEFATUL_DAYS);
        }
        return dailySignNewCacheAndLogic.getDays(new Date(),SIGN_DEFATUL_DAYS);
    }

    private Date days(Integer signDays,Date signDate,boolean isYesterday){
        if(signDays == 0){
            return new Date();
        }
        if(signDays%SIGN_DEFATUL_DAYS == 0){
            return isYesterday ? new Date()
                    : dailySignNewCacheAndLogic.getDay(signDate,SIGN_DEFATUL_DAYS);
        }
        return dailySignNewCacheAndLogic.getDay(signDate,signDays%SIGN_DEFATUL_DAYS);
    }
}
