package com.bxm.localnews.activity.strategy;

import com.bxm.localnews.activity.dto.NewsMissionRewardDto;
import com.bxm.localnews.activity.param.TaskContext;
import com.bxm.localnews.common.constant.TaskEnum;

public interface TaskStrategy {

    /**
     * 模版模式定义大体结构
     * -任务预处理，查找任务置入上下文
     * -完成对任务的处理
     * -完成对后续的处理（红花的增减以及消息的调用）
     *
     * @param taskContext
     * @return
     */
    NewsMissionRewardDto process(TaskContext taskContext);

    /**
     * 当前任务类型，判断策略是否支持
     *
     * @param taskEnum
     * @return
     */
    boolean support(TaskEnum taskEnum);

}
