package com.bxm.localnews.activity.strategy.dailyConcreteStrategy;

import com.bxm.localnews.activity.domain.BrowseRecordMapper;
import com.bxm.localnews.activity.dto.NewsMissionRewardDto;
import com.bxm.localnews.activity.param.TaskContext;
import com.bxm.localnews.common.config.NewsProperties;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.vo.Message;
import org.springframework.stereotype.Service;

/**
 * 发表评论任务完成
 * @author liujia
 */
@Service
public class NewsCommentTaskStrategy extends AbstractDailyTaskStrategy {

    public NewsCommentTaskStrategy(RedisStringAdapter redisStringAdapter,
                                   RedisHashMapAdapter redisHashMapAdapter,
                                   NewsProperties newsProperties,
                                   UserIntegrationService userIntegrationService,
                                   BrowseRecordMapper browseRecordMapper) {
        super(redisStringAdapter, redisHashMapAdapter, newsProperties, userIntegrationService, browseRecordMapper);
    }

    @Override
    protected Message customJudge(TaskContext taskContext) {
        return judgeIsOverRewardCount(taskContext);
    }

    @Override
    protected NewsMissionRewardDto processing(TaskContext taskContext) {
        return defaultProcess(taskContext);
    }

    @Override
    public boolean support(TaskEnum taskEnum) {
        return taskEnum.equals(TaskEnum.TASK_COMMENT_NEWS);
    }

    @Override
    protected boolean isSupportPushMessage() {
        //2.5.0 不发推送
        return false;
    }

    @Override
    protected long getTaskReward(TaskContext taskContext) {
        //2.5.0 不写入消息中心
        taskContext.setPersistenceMsg(false);
        return taskContext.getDailyTask().getReward().intValue();
    }


}
