package com.bxm.localnews.activity.task;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.integration.PushMsgIntegrationService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.tools.DateUtils;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author pf.w
 * @date 2020/11/2 9:57
 **/
@Component
@Slf4j
public class SignWarningPushMsgTask extends AbstractCronTask<String> {

    @Resource
    private PushMsgIntegrationService pushMsgIntegrationService;

    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Resource
    private RedisSetAdapter redisSetAdapter;

    @Override
    protected ReturnT<String> service(String s) {
        Set<String> userIds = redisHashMapAdapter.keys(signWarningKey());
        if(CollectionUtils.isEmpty(userIds)){
            return ReturnT.FAIL;
        }
        //开通签到通知的用户集合
        Set<Long> openSignWaningUsers = userIds.stream().map(Long::valueOf).collect(Collectors.toSet());

        //今日签到过的用户集合
        Date date = new Date();
        String today = DateUtils.formatDate(date);
        KeyGenerator signRecordKey = RedisConfig.SIGN_NOTIFICATION_KEY.copy().appendKey(today);
        Set<Long> signedTodayUsers = redisSetAdapter.getAllMembers(signRecordKey,Long.class);

        //取差集
        Set<Long> result = new HashSet<>(openSignWaningUsers);
        if(!CollectionUtils.isEmpty(signedTodayUsers)){
            result.removeAll(signedTodayUsers);
        }

        result.forEach(id->{
            String username = redisHashMapAdapter.get(signWarningKey(),id.toString(),String.class);
            pushMsgIntegrationService.pushSignWarningNotifyactionMsg(id,username);
        });
        return ReturnT.SUCCESS;
    }

    /**
     * 签到提醒开关key
     *
     * @return 签到key
     */
    private KeyGenerator signWarningKey(){
        return RedisConfig.SIGN_WARNING_OPERATE_KEY.copy();
    }

    @Override
    public String taskName() {
        return "SignWarningPushMsgTask";
    }

    @Override
    public String cron() {
        //每天上午九点执行推送
        return "0 0 9 * * ?";
    }

    @Override
    public String description() {
        return "签到提醒开关开启后的推送";
    }
}
