/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.merchant.action.stream;

import com.bxm.localnews.admin.dto.MessageDeleteForumDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.stereotype.Component;

/**
 * @author jieliGG
 * @date 2020/8/10 13:43
 * 统一的发送消息的接口
 **/
@Component
public class MessageOutHandler {
    @Autowired
    private MessageProcessor messageProcessor;

    /**
     * 发送消息
     * @param messageDeleteForumDTO
     */
    public void sendMsg(MessageDeleteForumDTO messageDeleteForumDTO){
        messageProcessor.deleteForumOutput().send(MessageBuilder.withPayload(messageDeleteForumDTO).build());
    }
}
