package com.bxm.localnews.admin.controller;

import javax.annotation.Resource;

import com.bxm.localnews.admin.param.NewsParam;
import com.bxm.localnews.admin.service.AdminNewsService;
import com.bxm.localnews.admin.vo.News;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "4-15 [管理]新闻管理", description = "新闻上线管理，防止受管制的内容出现在线上")
@RefreshScope
@RestController
@RequestMapping("api/admin/news")
public class AdminNewsController {

    @Resource
    private AdminNewsService adminNewsService;

    @ApiOperation(value = "4-15-1 获取新闻列表", notes = "")
    @GetMapping("/list")
    @RequiresPermissions("admin:news")
    public Json<PageWarper<News>> getNews(NewsParam newsParam) {

        return ResultUtil.genSuccessResult(this.adminNewsService.queryNews(newsParam));
    }

    @ApiOperation("4-15-2 新闻上下架")
    @PostMapping("/updateNews")
    @RequiresPermissions("admin:news")
    public Json updateNewsStatusById(Long id, Byte status) {
        News news = new News();
        news.setId(id);
        news.setStatus(status);

        int flag = this.adminNewsService.updateByPrimaryKeySelective(news);

        if (flag > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }

    @ApiOperation("4-15-3 新闻批量上下架")
    @PostMapping("/batchUpdateNews")
    @RequiresPermissions("admin:news")
    public Json updateNewsStatusByIds(String ids, Byte status) {
        String idsNew = ids.substring(1, ids.length() - 1);
        String id[] = idsNew.split(",");
        if (id.length > 0) {
            int flag = this.adminNewsService.updateNewsStatusByIds(id, status);

            if (flag > 0) {
                return ResultUtil.genSuccessMsg("更新成功");
            }
            return ResultUtil.genFailedResult("更新失败");
        } else {
            return ResultUtil.genFailedResult("请选择新闻");
        }
    }

    @ApiOperation("4-15-4 获取新闻详情")
    @GetMapping("/getNewsDetail")
    @RequiresPermissions("admin:news")
    public Json<News> getNewsDetail(Long id) {

        News news = this.adminNewsService.selectByPrimaryKey(id);

        return ResultUtil.genSuccessResult(news);
    }

}
