package com.bxm.localnews.admin.controller;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import com.bxm.localnews.admin.dto.AdminRoleDTO;
import com.bxm.localnews.admin.dto.MenuAndPermDTO;
import com.bxm.localnews.admin.dto.MenuDTO;
import com.bxm.localnews.admin.param.RoleParam;
import com.bxm.localnews.admin.service.*;
import com.bxm.localnews.admin.vo.AdminRole;
import com.bxm.localnews.admin.vo.AdminRoleMenu;
import com.bxm.localnews.admin.vo.AdminRolePerm;
import com.bxm.localnews.admin.vo.AdminUser;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

@Api(tags = "9-12 [管理]角色管理", description = "角色操作接口")
@Controller
@RequestMapping("api/admin/role")
public class AdminRoleController extends CommonController {

    @Resource
    private AdminRoleService adminRoleService;

    @Resource
    private AdminUserRoleService adminUserRoleService;

    @Resource
    private AdminMenuService adminMenuService;

    @Resource
    private AdminRoleMenuService adminRoleMenuService;

    @Resource
    private AdminRolePermService adminRolePermService;

    @ApiOperation(value = "9-12-1 获取全部角色", notes = "")
    @GetMapping("list")
    @ResponseBody
    @RequiresPermissions("admin:role")
    public Json<PageWarper<AdminRoleDTO>> getAllRoleList(RoleParam param) {

        return ResultUtil.genSuccessResult(this.adminRoleService.selectAll(param));
    }

    @ApiOperation(value = "9-12-2 保存角色信息", notes = "")
    @RequestMapping(value = "save", method = RequestMethod.POST)
    @ResponseBody
    @RequiresPermissions("admin:role")
    public Json saveRole(@RequestBody AdminRole adminRole) {
        AdminUser loginUser = this.getLoginUser();

        if (loginUser == null) {
            ResultUtil.genFailedResult("请先登录");
        }
        //判断唯一标示
        String roleCode = adminRole.getRoleCode();
        if (StringUtils.isEmpty(roleCode)) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "角色唯一标示为空");
        }
        AdminRole adminRole1 = this.adminRoleService.selectByRoleCode(roleCode);

        if (adminRole.getId() == null) {
            if (adminRole1 != null) {
                return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "角色唯一标示重复");
            }
            adminRole.setCreateTime(new Date());
            adminRole.setCreateUser(loginUser.getId());
            this.adminRoleService.insertSelective(adminRole);
        }

        if (null != adminRole1 && adminRole.getId() != null && null != adminRole.getRoleCode()) {
            if (adminRole1.getRoleCode().equals(adminRole.getRoleCode()) && !adminRole1.getId().equals(adminRole.getId())) {
                return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "角色唯一标示重复");
            }

            adminRole.setUpdateUser(loginUser.getId());
            adminRole.setUpdateTime(new Date());
            this.adminRoleService.updateByPrimaryKeySelective(adminRole);
        }

        return ResultUtil.genSuccessMsg();
    }

    @ApiOperation(value = "9-12-3 删除角色", notes = "")
    @ApiImplicitParam(name = "roleId", value = "角色id")
    @PostMapping(value = "delete")
    @ResponseBody
    @RequiresPermissions("admin:role")
    public Json delete(Integer roleId) {
        Integer userNum = this.adminUserRoleService.countByRoleId(roleId);
        if (userNum > 0) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "该角色关联其他用户，不能删除");
        }
        this.adminRoleService.deleteByPrimaryKey(roleId);
        return ResultUtil.genSuccessMsg();
    }

    @ApiOperation(value = "9-12-4 根据角色获取菜单和权限列表", notes = "")
    @ApiImplicitParam(name = "roleId", value = "角色id")
    @GetMapping("getMenuAndPerm")
    @ResponseBody
    @RequiresPermissions("admin:role")
    public Json<List<MenuDTO>> getMenuAndPerm(Integer roleId) {
        List<MenuDTO> menusAndPermsByRoleId = this.adminMenuService.getMenusAndPermsByRoleId(roleId);

        for (MenuDTO menuDTO : menusAndPermsByRoleId) {
            int i = 0;
            List<MenuDTO> children = menuDTO.getChildren();
            if (children != null && !children.isEmpty()) {
                for (MenuDTO child : children) {
                    if (child.getChecked() == 1) {
                        i++;
                    }
                }
                if (children.size() != i) {
                    menuDTO.setChecked(0);
                }
            }
        }
        return ResultUtil.genSuccessResult(menusAndPermsByRoleId);
    }

    /**
     * 保存角色拥有菜单和权限
     * @param menuAndPermDTO
     * @return
     */
    @ApiOperation(value = "9-12-5 保存角色拥有菜单和权限", notes = "")
    @RequestMapping(value = "saveMenuAndPerm", method = RequestMethod.POST)
    @ResponseBody
    @RequiresPermissions("admin:role")
    public Json saveMenuAndPerm(@RequestBody MenuAndPermDTO menuAndPermDTO) {

        Integer roleId = menuAndPermDTO.getRoleId();
        if (roleId == null) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "角色id为空");
        }

        AdminRole adminRole = this.adminRoleService.selectByPrimaryKey(roleId);

        if (adminRole != null) {

            //清空角色对应的菜单和权限
            this.adminRoleMenuService.deleteByRoleId(roleId);
            //重新保存
            for (Integer menuId : menuAndPermDTO.getMenuIds()) {
                AdminRoleMenu adminRoleMenu = new AdminRoleMenu();
                adminRoleMenu.setMenuId(menuId);
                adminRoleMenu.setRoleId(roleId);
                this.adminRoleMenuService.insertSelective(adminRoleMenu);
            }

            this.adminRolePermService.deleteByRoleId(roleId);
            for (Integer permId : menuAndPermDTO.getPermIds()) {
                AdminRolePerm adminRolePerm = new AdminRolePerm();
                adminRolePerm.setPermId(permId);
                adminRolePerm.setRoleId(roleId);
                this.adminRolePermService.insertSelective(adminRolePerm);
            }
            return ResultUtil.genSuccessMsg();
        }
        return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "角色不存在");
    }

}
