package com.bxm.localnews.admin.controller;

import com.bxm.localnews.message.param.MessageParam;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.message.service.MessageService;
import com.bxm.localnews.message.service.PushMessageService;
import com.bxm.localnews.message.service.PushMsgSupplyService;
import com.bxm.localnews.message.vo.Message;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.Date;

@Api(tags = "1-14 [管理]系统发送消息管理接口", description = "消息队列中的消息管理")
@Controller
@RequestMapping("api/admin/message")
public class AdminMessageController {

    private final static Logger logger = LoggerFactory.getLogger(AdminMessageController.class);

    @Resource
    private MessageService messageService;

    @Resource
    private PushMessageService pushMessageService;

    @Resource
    private PushMsgSupplyService pushMsgSupplyService;

    @ApiOperation(value = "消息列表", notes = "查询消息列表")
    @RequestMapping(value = "queryMessageList", method = RequestMethod.GET)
    @ResponseBody
    @RequiresPermissions("admin:message")
    public Json<PageWarper<Message>> queryMessageList(MessageParam messageParam) {

        return ResultUtil.genSuccessResult(this.messageService.queryMessages(messageParam));
    }

    @ApiOperation(value = "保存消息", notes = "保存或者更新消息")
    @RequestMapping(value = "saveOrUpdateMsgInfo", method = RequestMethod.GET)
    @ResponseBody
    @RequiresPermissions("admin:message")
    public Json addMsgInfo(Message message) {
        //TODO [zhaoyadong]时间：sendType可设置成枚举类型
        try {
            if (message.getId() == null) {
                if (message.getSendType() == 0) {
                    message.setSendState(1);
                    String sendTime = DateUtils.formatDateTime(new Date());// new
                    // Date()为获取当前系统时间
                    message.setSendTime(sendTime);
                    this.messageService.insertSelective(message);
                } else {
                    message.setSendState(0);
                    message.setSendTime(message.getSendTime());
                    //TODO 消息延后消费
                }
                if (message.getSendType() == 0) {
                    this.pushMsgSupplyService.pushMsgToAll(message.getTitle(), message.getContent(), null);
                }

                return ResultUtil.genSuccessMsg("新增成功");
            } else {
                if (message.getSendType() == 0) {
                    message.setSendState(1);
                    String sendTime = DateUtils.formatDateTime(new Date());// new
                    // Date()为获取当前系统时间
                    message.setSendTime(sendTime);
                    this.pushMsgSupplyService.pushMsgToAll(message.getTitle(), message.getContent(), null);
                } else {
                    message.setSendState(0);
                    message.setSendTime(message.getSendTime());
                    //TODO 消息延后消费
                }
                this.messageService.updateByPrimaryKeySelective(message);
                return ResultUtil.genSuccessMsg("修改成功");
            }
        } catch (Exception e) {
            logger.error("saveOrUpdateMsgInfo", e);
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "操作失败");
        }
    }

    @ApiOperation(value = "删除消息", notes = "")
    @ApiImplicitParam(name = "messageId", value = "消息id")
    @RequestMapping(value = "deleteMsgInfo", method = RequestMethod.GET)
    @ResponseBody
    @RequiresPermissions("admin:message")
    public Json updateMsgInfo(@RequestParam(value = "messageId", required = false) String messageId) {
        if (StringUtils.isEmpty(messageId)) {
            return ResultUtil.genFailedResult("参数错误");
        }
        try {
            this.messageService.deleteByPrimaryKey(Long.parseLong(messageId));
            return ResultUtil.genSuccessMsg("删除成功");
        } catch (Exception e) {
            logger.error("deleteMsgInfo", e);
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "操作失败");
        }
    }

    @ApiOperation(value = "消息详情", notes = "获取消息详情")
    @ApiImplicitParam(name = "messageId", value = "消息id")
    @RequestMapping(value = "getMsgInfo", method = RequestMethod.GET)
    @ResponseBody
    @RequiresPermissions("admin:message")
    public Json<Message> getMsgInfo(@RequestParam(value = "messageId", required = true) String messageId) {
        if (StringUtils.isEmpty(messageId)) {
            return ResultUtil.genFailedResult("参数错误");
        }
        try {
            Message messageInfo = this.messageService.selectByPrimaryKey(Long.parseLong(messageId));
            return ResultUtil.genSuccessResult(messageInfo);
        } catch (Exception e) {
            logger.error("getMsgInfoError", e);
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "操作失败");
        }
    }

}
