/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller.activity;

import com.bxm.localnews.admin.param.MessageParam;
import com.bxm.localnews.admin.service.PushMsgIntegService;
import com.bxm.localnews.admin.service.activity.AdminMessageService;
import com.bxm.localnews.admin.vo.Message;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"1-06 [\u7ba1\u7406]\u7cfb\u7edf\u53d1\u9001\u6d88\u606f\u7ba1\u7406\u63a5\u53e3"}, description="\u6d88\u606f\u961f\u5217\u4e2d\u7684\u6d88\u606f\u7ba1\u7406")
@Controller
@RequestMapping(value={"api/admin/message"})
public class AdminMessageController {
    private static final Logger logger = LoggerFactory.getLogger(AdminMessageController.class);
    @Resource
    private AdminMessageService adminMessageService;
    @Resource
    private PushMsgIntegService pushMsgIntegService;

    @ApiOperation(value="1-6-1 \u6d88\u606f\u5217\u8868", notes="\u67e5\u8be2\u6d88\u606f\u5217\u8868")
    @RequestMapping(value={"queryMessageList"}, method={RequestMethod.GET})
    @ResponseBody
    public Json<PageWarper<Message>> queryMessageList(MessageParam messageParam) {
        return ResultUtil.genSuccessResult((Object)this.adminMessageService.queryMessages(messageParam));
    }

    @ApiOperation(value="1-6-2 \u4fdd\u5b58\u6d88\u606f", notes="\u4fdd\u5b58\u6216\u8005\u66f4\u65b0\u6d88\u606f")
    @RequestMapping(value={"saveOrUpdateMsgInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public Json addMsgInfo(Message message) {
        try {
            if (message.getId() == null) {
                if (message.getSendType() == 0) {
                    message.setSendState(Integer.valueOf(1));
                    String sendTime = DateUtils.formatDateTime((Date)new Date());
                    message.setSendTime(sendTime);
                    this.adminMessageService.insertSelective(message);
                } else {
                    message.setSendState(Integer.valueOf(0));
                    message.setSendTime(message.getSendTime());
                }
                return ResultUtil.genSuccessMsg((String)"\u65b0\u589e\u6210\u529f");
            }
            if (message.getSendType() == 0) {
                message.setSendState(Integer.valueOf(1));
                String sendTime = DateUtils.formatDateTime((Date)new Date());
                message.setSendTime(sendTime);
            } else {
                message.setSendState(Integer.valueOf(0));
                message.setSendTime(message.getSendTime());
            }
            this.adminMessageService.updateByPrimaryKeySelective(message);
            return ResultUtil.genSuccessMsg((String)"\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("saveOrUpdateMsgInfo", (Throwable)e);
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @ApiOperation(value="1-6-3 \u5220\u9664\u6d88\u606f", notes="")
    @ApiImplicitParam(name="messageId", value="\u6d88\u606fid")
    @RequestMapping(value={"deleteMsgInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public Json updateMsgInfo(@RequestParam(value="messageId", required=false) String messageId) {
        if (StringUtils.isEmpty((CharSequence)messageId)) {
            return ResultUtil.genFailedResult((String)"\u53c2\u6570\u9519\u8bef");
        }
        try {
            this.adminMessageService.deleteByPrimaryKey(Long.valueOf(Long.parseLong(messageId)));
            return ResultUtil.genSuccessMsg((String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("deleteMsgInfo", (Throwable)e);
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @ApiOperation(value="1-6-4 \u6d88\u606f\u8be6\u60c5", notes="\u83b7\u53d6\u6d88\u606f\u8be6\u60c5")
    @ApiImplicitParam(name="messageId", value="\u6d88\u606fid")
    @RequestMapping(value={"getMsgInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public Json<Message> getMsgInfo(@RequestParam(value="messageId", required=true) String messageId) {
        if (StringUtils.isEmpty((CharSequence)messageId)) {
            return ResultUtil.genFailedResult((String)"\u53c2\u6570\u9519\u8bef");
        }
        try {
            Message messageInfo = this.adminMessageService.selectByPrimaryKey(Long.valueOf(Long.parseLong(messageId)));
            return ResultUtil.genSuccessResult((Object)messageInfo);
        }
        catch (Exception e) {
            logger.error("getMsgInfoError", (Throwable)e);
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u64cd\u4f5c\u5931\u8d25");
        }
    }
}

