/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller.base;

import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.dto.AdminMenuDTO;
import com.bxm.localnews.admin.dto.AdminRoleDTO;
import com.bxm.localnews.admin.dto.AppVersionDTO;
import com.bxm.localnews.admin.dto.MenuAndPermDTO;
import com.bxm.localnews.admin.dto.MenuDTO;
import com.bxm.localnews.admin.param.AppVersionParam;
import com.bxm.localnews.admin.param.RoleParam;
import com.bxm.localnews.admin.service.base.AdminAppVersionService;
import com.bxm.localnews.admin.service.security.AdminMenuService;
import com.bxm.localnews.admin.service.security.AdminRoleMenuService;
import com.bxm.localnews.admin.service.security.AdminRolePermService;
import com.bxm.localnews.admin.service.security.AdminRoleService;
import com.bxm.localnews.admin.service.security.AdminUserRoleService;
import com.bxm.localnews.admin.vo.AdminMenu;
import com.bxm.localnews.admin.vo.AdminRole;
import com.bxm.localnews.admin.vo.AdminRoleMenu;
import com.bxm.localnews.admin.vo.AdminRolePerm;
import com.bxm.localnews.admin.vo.AdminUser;
import com.bxm.localnews.admin.vo.AppVersion;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-25 [\u7ba1\u7406]App\u7248\u672c\u7ba1\u7406"}, description="App\u7248\u672c\u7ba1\u7406\u7684\u76f8\u5173\u64cd\u4f5c")
@RestController
@RequestMapping(value={"api/admin/appversion"})
public class AdminAppVersionController
extends BaseController {
    private AdminAppVersionService adminAppVersionService;

    @Autowired
    public AdminAppVersionController(AdminAppVersionService adminAppVersionService) {
        this.adminAppVersionService = adminAppVersionService;
    }

    @ApiOperation(value="1-25-1 \u83b7\u53d6App\u7248\u672c\u5217\u8868", notes="\u6839\u636e\u8f93\u5165\u53c2\u6570\u83b7\u53d6\u5bf9\u5e94\u7684\u7248\u672c\u6570\u636e")
    @GetMapping(value={"/list"})
    public Json<PageWarper<AppVersionDTO>> getAppVersionList(AppVersionParam appVersionParam) {
        return ResultUtil.genSuccessResult((Object)this.adminAppVersionService.getAppVersionList(appVersionParam));
    }

    @ApiOperation(value="1-25-2 \u83b7\u53d6App\u7248\u672c\u8be6\u60c5", notes="\u83b7\u53d6\u5bf9\u5e94\u7684\u7248\u672c\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true)})
    @GetMapping(value={"/detail"})
    public Json<AppVersionDTO> getAppVersionById(Long id) {
        return ResultUtil.genSuccessResult((Object)this.adminAppVersionService.getAppVersionById(id));
    }

    @ApiOperation(value="1-25-3 app\u7248\u672c\u4fe1\u606f\u6279\u91cf\u66f4\u65b0\u5ba1\u6838\u72b6\u6001\u548c\u7248\u672c\u66f4\u65b0\u65b9\u5f0f", notes="", hidden=true)
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u5b57\u7b26\u4e32\uff0c\u4ee5\u201d,\u201c\u5206\u9694", required=true), @ApiImplicitParam(name="status", value="\u72b6\u6001", required=false), @ApiImplicitParam(name="force", value="\u66f4\u65b0\u65b9\u5f0f", required=false)})
    @PostMapping(value={"/batchUpdateStatus"})
    public Json updateAppVersionStatusByIds(String ids, Byte status, Byte force) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return ResultUtil.genFailedResult((String)"\u7248\u672c\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        String[] id = ids.split(",");
        if (this.adminAppVersionService.updateAppVersionStatusById(id, status, force) > 0) {
            return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @ApiOperation(value="1-25-4 app\u7248\u672c\u4fe1\u606f\u66f4\u65b0\u5ba1\u6838\u72b6\u6001\u548c\u7248\u672c\u66f4\u65b0\u65b9\u5f0f", notes="")
    @PostMapping(value={"/updateStatus"})
    public Json updateAppVersionStatusById(AppVersion appVersion) {
        if (this.adminAppVersionService.updateAppVersionStatusById(appVersion) > 0) {
            return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @ApiOperation(value="1-25-5 \u65b0\u589e\u6216\u7f16\u8f91\u7248\u672c\u4fe1\u606f", notes="")
    @PostMapping(value={"/saveOrUpdateAppVersion"})
    public Json addAdvertDetail(AppVersion appVersion) {
        if (this.adminAppVersionService.addAppVersionDetail(appVersion) > 0) {
            return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @Api(tags={"1-13 [\u7ba1\u7406]\u89d2\u8272\u7ba1\u7406"}, description="\u89d2\u8272\u64cd\u4f5c\u63a5\u53e3")
    @Controller
    @RequestMapping(value={"api/admin/role"})
    public static class AdminRoleController
    extends CommonController {
        @Resource
        private AdminRoleService adminRoleService;
        @Resource
        private AdminUserRoleService adminUserRoleService;
        @Resource
        private AdminMenuService adminMenuService;
        @Resource
        private AdminRoleMenuService adminRoleMenuService;
        @Resource
        private AdminRolePermService adminRolePermService;

        @ApiOperation(value="1-13-1 \u83b7\u53d6\u5168\u90e8\u89d2\u8272", notes="")
        @GetMapping(value={"list"})
        @ResponseBody
        public Json<PageWarper<AdminRoleDTO>> getAllRoleList(RoleParam param) {
            return ResultUtil.genSuccessResult((Object)this.adminRoleService.selectAll(param));
        }

        @ApiOperation(value="1-13-2 \u4fdd\u5b58\u89d2\u8272\u4fe1\u606f", notes="")
        @RequestMapping(value={"save"}, method={RequestMethod.POST})
        @ResponseBody
        public Json saveRole(@RequestBody AdminRole adminRole) {
            String roleCode;
            AdminUser loginUser = this.getLoginUser();
            if (loginUser == null) {
                ResultUtil.genFailedResult((String)"\u8bf7\u5148\u767b\u5f55");
            }
            if (StringUtils.isEmpty((CharSequence)(roleCode = adminRole.getRoleCode()))) {
                return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u89d2\u8272\u552f\u4e00\u6807\u793a\u4e3a\u7a7a");
            }
            AdminRole adminRole1 = this.adminRoleService.selectByRoleCode(roleCode);
            if (adminRole.getId() == null) {
                if (adminRole1 != null) {
                    return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u89d2\u8272\u552f\u4e00\u6807\u793a\u91cd\u590d");
                }
                adminRole.setCreateTime(new Date());
                adminRole.setCreateUser(loginUser.getId());
                this.adminRoleService.insertSelective(adminRole);
            }
            if (null != adminRole1 && adminRole.getId() != null && null != adminRole.getRoleCode()) {
                if (adminRole1.getRoleCode().equals(adminRole.getRoleCode()) && !adminRole1.getId().equals(adminRole.getId())) {
                    return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u89d2\u8272\u552f\u4e00\u6807\u793a\u91cd\u590d");
                }
                adminRole.setUpdateUser(loginUser.getId());
                adminRole.setUpdateTime(new Date());
                this.adminRoleService.updateByPrimaryKeySelective(adminRole);
            }
            return ResultUtil.genSuccessMsg();
        }

        @ApiOperation(value="1-13-3 \u5220\u9664\u89d2\u8272", notes="")
        @ApiImplicitParam(name="roleId", value="\u89d2\u8272id")
        @PostMapping(value={"delete"})
        @ResponseBody
        public Json delete(Integer roleId) {
            Integer userNum = this.adminUserRoleService.countByRoleId(roleId);
            if (userNum > 0) {
                return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u8be5\u89d2\u8272\u5173\u8054\u5176\u4ed6\u7528\u6237\uff0c\u4e0d\u80fd\u5220\u9664");
            }
            this.adminRoleService.deleteByPrimaryKey(roleId);
            return ResultUtil.genSuccessMsg();
        }

        @ApiOperation(value="1-13-4 \u6839\u636e\u89d2\u8272\u83b7\u53d6\u83dc\u5355\u548c\u6743\u9650\u5217\u8868", notes="")
        @ApiImplicitParam(name="roleId", value="\u89d2\u8272id")
        @GetMapping(value={"getMenuAndPerm"})
        @ResponseBody
        public Json<List<MenuDTO>> getMenuAndPerm(Integer roleId) {
            List menusAndPermsByRoleId = this.adminMenuService.getMenusAndPermsByRoleId(roleId);
            for (MenuDTO menuDTO : menusAndPermsByRoleId) {
                int i = 0;
                List children = menuDTO.getChildren();
                if (children == null || children.isEmpty()) continue;
                for (MenuDTO child : children) {
                    if (child.getChecked() != 1) continue;
                    ++i;
                }
                if (children.size() == i) continue;
                menuDTO.setChecked(Integer.valueOf(0));
            }
            return ResultUtil.genSuccessResult((Object)menusAndPermsByRoleId);
        }

        @ApiOperation(value="1-13-5 \u4fdd\u5b58\u89d2\u8272\u62e5\u6709\u83dc\u5355\u548c\u6743\u9650", notes="")
        @RequestMapping(value={"saveMenuAndPerm"}, method={RequestMethod.POST})
        @ResponseBody
        public Json saveMenuAndPerm(@RequestBody MenuAndPermDTO menuAndPermDTO) {
            Integer roleId = menuAndPermDTO.getRoleId();
            if (roleId == null) {
                return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u89d2\u8272id\u4e3a\u7a7a");
            }
            AdminRole adminRole = this.adminRoleService.selectByPrimaryKey(roleId);
            if (adminRole != null) {
                this.adminRoleMenuService.deleteByRoleId(roleId);
                for (Integer menuId : menuAndPermDTO.getMenuIds()) {
                    AdminRoleMenu adminRoleMenu = new AdminRoleMenu();
                    adminRoleMenu.setMenuId(menuId);
                    adminRoleMenu.setRoleId(roleId);
                    this.adminRoleMenuService.insertSelective(adminRoleMenu);
                }
                this.adminRolePermService.deleteByRoleId(roleId);
                for (Integer permId : menuAndPermDTO.getPermIds()) {
                    AdminRolePerm adminRolePerm = new AdminRolePerm();
                    adminRolePerm.setPermId(permId);
                    adminRolePerm.setRoleId(roleId);
                    this.adminRolePermService.insertSelective(adminRolePerm);
                }
                return ResultUtil.genSuccessMsg();
            }
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u89d2\u8272\u4e0d\u5b58\u5728");
        }
    }

    @Api(tags={"1-05 [\u7ba1\u7406]\u83dc\u5355\u7ba1\u7406"}, description="\u83dc\u5355\u680f\u76f8\u5173\u64cd\u4f5c")
    @Controller
    @RequestMapping(value={"api/admin/menu"})
    public static class AdminMenuController {
        @Resource
        private AdminMenuService adminMenuService;
        @Resource
        private AdminRoleMenuService adminRoleMenuService;

        @ApiOperation(value="1-5-1 \u6839\u636e\u7528\u6237\u89d2\u8272\u83b7\u53d6\u62e5\u6709\u7684\u83dc\u5355")
        @ApiImplicitParam(name="roleId", value="\u89d2\u8272id")
        @GetMapping(value={"getRoleMenu"})
        @ResponseBody
        public Json<List<AdminMenuDTO>> getRoleMenu(Integer roleId) {
            if (roleId == null) {
                return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u4e3a\u7a7a");
            }
            return ResultUtil.genSuccessResult((Object)this.adminMenuService.getMenusByRoleId(roleId));
        }

        @ApiOperation(value="1-5-2 \u6839\u636e\u89d2\u8272\u83b7\u53d6\u83dc\u5355\u5217\u8868")
        @ApiImplicitParam(name="roleId", value="\u89d2\u8272id")
        @GetMapping(value={"getUserMenu"})
        @ResponseBody
        public Json<List<AdminMenuDTO>> getMenuByUserId(Long roleId) {
            List allMenus = this.adminMenuService.getMenusByRole(roleId);
            return ResultUtil.genSuccessResult((Object)allMenus);
        }

        @ApiOperation(value="1-5-3 \u83b7\u53d6\u6240\u6709\u83dc\u5355\u5217\u8868")
        @GetMapping(value={"getAllMenu"})
        @ResponseBody
        public Json<List<AdminMenuDTO>> getAllMenu() {
            List allMenus = this.adminMenuService.getAllMenu();
            return ResultUtil.genSuccessResult((Object)allMenus);
        }

        @ApiOperation(value="1-5-4 \u83b7\u53d6\u83dc\u5355\u8be6\u60c5")
        @ApiImplicitParam(name="menuId", value="\u83dc\u5355id")
        @ResponseBody
        @GetMapping(value={"getMenuInfo"})
        public Json<AdminMenu> getMenuInfo(@RequestParam(value="menuId") Integer menuId) {
            AdminMenu menu = this.adminMenuService.selectByPrimaryKey(menuId);
            return ResultUtil.genSuccessResult((Object)menu);
        }

        @ApiOperation(value="1-5-5 \u83b7\u53d6\u7236\u8282\u70b9\u83dc\u5355")
        @GetMapping(value={"getParentMenuList"})
        @ResponseBody
        public Json<List<AdminMenu>> getParentMenuList() {
            return ResultUtil.genSuccessResult((Object)this.adminMenuService.getParentMenus());
        }

        @ApiOperation(value="1-5-6 \u4fdd\u5b58\u83dc\u5355")
        @RequestMapping(value={"save"}, method={RequestMethod.POST})
        @ResponseBody
        public Json saveMenu(@RequestBody AdminMenu adminMenu) {
            if (StringUtils.isEmpty((CharSequence)adminMenu.getName()) || adminMenu.getLevel() == 1 && StringUtils.isEmpty((CharSequence)adminMenu.getPath())) {
                return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u83dc\u5355\u540d\u79f0\u4e3a\u7a7a\u6216\u5b50\u83dc\u5355\u8def\u5f84\u4e3a\u7a7a");
            }
            int flag = this.adminMenuService.upsert(adminMenu);
            if (flag == 1 || flag > 1) {
                return ResultUtil.genSuccessMsg();
            }
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u6570\u636e\u5e93\u5f02\u5e38");
        }

        @ApiOperation(value="1-5-7 \u5220\u9664\u83dc\u5355")
        @ApiImplicitParam(name="menuId", value="\u83dc\u5355id", required=true)
        @PostMapping(value={"delete"})
        @ResponseBody
        public Json delete(Integer menuId) {
            Integer userNum = this.adminRoleMenuService.countByMenuId(menuId);
            if (userNum > 0) {
                return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u8be5\u83dc\u5355\u5173\u8054\u5176\u4ed6\u89d2\u8272\uff0c\u4e0d\u80fd\u5220\u9664");
            }
            this.adminMenuService.deleteByPrimaryKey(menuId);
            return ResultUtil.genSuccessMsg();
        }
    }
}

