/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller.base;

import com.bxm.localnews.admin.param.TaskParam;
import com.bxm.localnews.admin.service.activity.TaskService;
import com.bxm.localnews.admin.vo.TaskBean;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-14 [\u7ba1\u7406]\u4efb\u52a1\u7ba1\u7406"}, description="\u4efb\u52a1\u7ba1\u7406\u7684\u76f8\u5173\u64cd\u4f5c")
@RestController
@RequestMapping(value={"api/admin/task"})
public class AdminTaskController
extends BaseController {
    private TaskService taskService;

    @Autowired
    public AdminTaskController(TaskService taskService) {
        this.taskService = taskService;
    }

    @ApiOperation(value="1-14-1 \u83b7\u53d6\u4efb\u52a1\u5217\u8868")
    @GetMapping(value={"/list"})
    public Json<PageWarper<TaskBean>> getTask(TaskParam param) {
        PageWarper result = this.taskService.queryTaskByPage(param);
        return ResultUtil.genSuccessResult((Object)result);
    }

    @ApiOperation(value="1-14-2 \u4efb\u52a1\u6279\u91cf\u4e0a\u4e0b\u67b6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u5b57\u7b26\u4e32\uff0c\u4ee5\u201d,\u201c\u5206\u9694", required=true), @ApiImplicitParam(name="state", value="\u72b6\u6001", required=true)})
    @PostMapping(value={"/batchUpdateTasks"})
    public Json updateNewsStatusByIds(String ids, Byte state) {
        Message result = this.taskService.modifyTaskStatus(state, StringUtils.split((String)ids, (String)","));
        return Json.build((Message)result);
    }

    @ApiOperation(value="1-14-3 \u83b7\u53d6\u4efb\u52a1\u8be6\u60c5")
    @ApiImplicitParam(name="id", value="\u4efb\u52a1id", required=true)
    @GetMapping(value={"/getTaskDetail"})
    public Json<TaskBean> getNewsDetail(Long id) {
        return ResultUtil.genSuccessResult((Object)this.taskService.getTaskById(id));
    }

    @ApiOperation(value="1-14-4 \u4efb\u52a1\u4e0a\u4e0b\u67b6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true), @ApiImplicitParam(name="state", value="\u72b6\u6001", required=true)})
    @PostMapping(value={"/updateTask"})
    public Json updateNewsStatusById(Long id, Byte state) {
        return Json.build((Message)this.taskService.modifyTaskStatus(state, new String[]{id.toString()}));
    }
}

