/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller.market;

import com.bxm.localnews.admin.config.MarketProperties;
import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.param.MarketCommodityQueryParam;
import com.bxm.localnews.admin.service.market.MarketCommodityService;
import com.bxm.localnews.admin.vo.AdminUser;
import com.bxm.localnews.admin.vo.MarketCommodity;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-50 [\u7ba1\u7406]\u5546\u54c1\u7ba1\u7406"}, description="\u79ef\u5206\u5546\u57ce\u5546\u54c1\u7ba1\u7406")
@RestController
@RequestMapping(value={"api/admin/marketCommodity"})
public class MarketCommodityController
extends CommonController {
    @Resource
    private MarketCommodityService marketCommodityService;
    @Resource
    private MarketProperties marketProperties;

    @ApiOperation(value="1-50-1 \u83b7\u53d6\u5546\u54c1\u5217\u8868")
    @GetMapping(value={"list"})
    public Json<PageWarper<MarketCommodity>> getList(MarketCommodityQueryParam param) {
        return ResultUtil.genSuccessResult((Object)this.marketCommodityService.getList(param));
    }

    @ApiOperation(value="1-50-2 \u83b7\u53d6\u5546\u54c1\u8be6\u60c5")
    @GetMapping(value={"detail"})
    public Json<MarketCommodity> getMarketCommodityById(Long id) {
        return ResultUtil.genSuccessResult((Object)this.marketCommodityService.selectByPrimaryKey(id));
    }

    @ApiOperation(value="1-50-3 \u5546\u54c1\u4e0a\u4e0b\u67b6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5546\u54c1id", required=true), @ApiImplicitParam(name="status", value="\u72b6\u6001\uff1a0\u4e0b\u67b6 1\u4e0a\u67b6", required=true)})
    @PostMapping(value={"updateStatus"})
    public Json updateStatusById(Long id, Byte status) {
        return ResultUtil.genSuccessResult((Object)this.marketCommodityService.updateStatus(id, status));
    }

    @ApiOperation(value="1-50-4 \u65b0\u589e\u6216\u7f16\u8f91\u5546\u54c1")
    @PostMapping(value={"saveOrUpdate"})
    public Json saveOrUpdate(@RequestBody MarketCommodity marketCommodity) {
        return ResultUtil.genSuccessResult((Object)this.marketCommodityService.saveOrUpdate(marketCommodity));
    }

    @ApiOperation(value="1-50-5 \u4fee\u6539\u5546\u54c1\u6743\u91cd")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5546\u54c1id", required=true), @ApiImplicitParam(name="order", value="\u6743\u91cd", required=true)})
    @PostMapping(value={"updateOrder"})
    public Json updateOrderById(Long id, Integer order) {
        return ResultUtil.genSuccessResult((Object)this.marketCommodityService.updateOrder(id, order));
    }

    @ApiOperation(value="1-50-6 \u5220\u9664\u5546\u54c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5546\u54c1id", required=true)})
    @PostMapping(value={"delete"})
    public Json deleteById(Long id) {
        AdminUser user = this.getLoginUser();
        if (null == user) {
            return ResultUtil.genFailedResult((String)"\u5f53\u524d\u65e0\u767b\u5f55\u7528\u6237");
        }
        return ResultUtil.genSuccessResult((Object)this.marketCommodityService.deleteById(id, user.getId()));
    }

    @ApiOperation(value="1-50-7 \u91d1\u5e01\u5151\u6362\u6bd4\u7387\u63a5\u53e3", notes="\u91d1\u5e01\u5151\u6362\u6bd4\u7387\u63a5\u53e3")
    @GetMapping(value={"/goldRate"})
    public Json<BigDecimal> goldRate() {
        return ResultUtil.genSuccessResult((Object)this.marketProperties.getGoldRate());
    }
}

