/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller.news;

import com.bxm.localnews.admin.dto.ContentDTO;
import com.bxm.localnews.admin.dto.NewsTagDTO;
import com.bxm.localnews.admin.enums.ShowLevelEnum;
import com.bxm.localnews.admin.param.CrawlingParam;
import com.bxm.localnews.admin.param.MixPoolParam;
import com.bxm.localnews.admin.param.NewsAddParam;
import com.bxm.localnews.admin.param.NewsParam;
import com.bxm.localnews.admin.param.NewsUpdateParam;
import com.bxm.localnews.admin.service.news.AdminNewsService;
import com.bxm.localnews.admin.vo.News;
import com.bxm.localnews.admin.vo.NewsKind;
import com.bxm.localnews.admin.vo.NewsOverView;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-07 [\u7ba1\u7406]\u65b0\u95fb\u7ba1\u7406"}, description="\u65b0\u95fb\u4e0a\u7ebf\u7ba1\u7406\uff0c\u9632\u6b62\u53d7\u7ba1\u5236\u7684\u5185\u5bb9\u51fa\u73b0\u5728\u7ebf\u4e0a")
@RestController
@RequestMapping(value={"api/admin/news"})
public class AdminNewsController
extends BaseController {
    @Resource
    private AdminNewsService adminNewsService;

    @ApiOperation(value="1-7-1 \u83b7\u53d6\u65b0\u95fb\u5217\u8868", notes="")
    @PostMapping(value={"/list"})
    public Json<PageWarper<NewsOverView>> getNews(NewsParam newsParam) {
        if (newsParam.getPageNum() != null && newsParam.getPageNum() * newsParam.getPageSize() > 10000) {
            return ResultUtil.genFailedResult((String)"\u4eb2,\u6682\u4e0d\u652f\u6301\u6570\u636e\u91cf10000\u4ee5\u4e0a\u7684\u5206\u9875\u54df\uff0c\u8bf7\u4f7f\u7528\u641c\u7d22\u529f\u80fd\u67e5\u627e\u65b0\u95fb\uff0c\u5982\u6709\u786c\u6027\u8981\u6c42\u8bf7\u8054\u7cfb\u6c88\u6d9b");
        }
        return ResultUtil.genSuccessResult((Object)this.adminNewsService.queryNews(newsParam));
    }

    @ApiOperation(value="1-7-2 \u65b0\u95fb\u4e0a\u4e0b\u67b6")
    @Deprecated
    @PostMapping(value={"/updateNews"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true), @ApiImplicitParam(name="status", value="\u72b6\u6001", required=true)})
    public Json updateNewsStatusById(Long id, Byte status) {
        News news = new News();
        news.setId(id);
        news.setStatus(status);
        int flag = this.adminNewsService.updateByPrimaryKeySelective(news);
        if (flag > 0) {
            return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @ApiOperation(value="1-7-3 \u65b0\u95fb\u6279\u91cf\u4e0a\u4e0b\u67b6")
    @Deprecated
    @PostMapping(value={"/batchUpdateNews"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u5b57\u7b26\u4e32\uff0c\u4ee5\u201d,\u201c\u5206\u9694", required=true), @ApiImplicitParam(name="status", value="\u72b6\u6001", required=true)})
    public Json updateNewsStatusByIds(String ids, Byte status) {
        String idsNew = ids.substring(1, ids.length() - 1);
        String[] id = idsNew.split(",");
        if (id.length > 0) {
            int flag = this.adminNewsService.updateNewsStatusByIds(id, status);
            if (flag > 0) {
                return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
            }
            return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
        }
        return ResultUtil.genFailedResult((String)"\u8bf7\u9009\u62e9\u65b0\u95fb");
    }

    @ApiOperation(value="1-7-4 \u83b7\u53d6\u65b0\u95fb\u8be6\u60c5")
    @Deprecated
    @GetMapping(value={"/getNewsDetail"})
    public Json<News> getNewsDetail(Long id) {
        News news = this.adminNewsService.selectByPrimaryKey(id);
        return ResultUtil.genSuccessResult((Object)news);
    }

    @ApiOperation(value="1-7-5 \u65b0\u95fb\u7f6e\u9876")
    @Deprecated
    @PostMapping(value={"/topping"})
    public Json toppingNews(Long id) {
        return this.adminNewsService.settingLevel(ShowLevelEnum.TOP, id);
    }

    @ApiOperation(value="1-7-6 \u5c06\u65b0\u95fb\u7f6e\u4e3a\u70ed\u95e8")
    @Deprecated
    @PostMapping(value={"/popularize"})
    public Json popularizeNews(Long id) {
        return this.adminNewsService.settingLevel(ShowLevelEnum.HOT, id);
    }

    @ApiOperation(value="1-7-7 \u65b0\u589e\u65b0\u95fb")
    @PostMapping(value={"/add"})
    public Json add(NewsAddParam param) {
        return this.adminNewsService.addNews(param);
    }

    @ApiOperation(value="1-7-8 \u4fee\u6539\u65b0\u95fb")
    @PostMapping(value={"/update"})
    public Json update(NewsUpdateParam param) {
        return this.adminNewsService.updateNews(param);
    }

    @ApiOperation(value="1-7-9 \u83b7\u53d6\u6240\u6709\u65b0\u95fb\u9891\u9053[\u5305\u62ec\u663e\u793a\u4e0e\u9690\u85cf]")
    @GetMapping(value={"/getAllKind"})
    public Json<List<NewsKind>> getAllKind() {
        List list = this.adminNewsService.getAllKind();
        return ResultUtil.genSuccessResult((Object)list);
    }

    @ApiOperation(value="1-7-10 \u6839\u636e\u6587\u7ae0\u94fe\u63a5\u6293\u53d6\u6587\u7ae0\u5185\u5bb9")
    @PostMapping(value={"/getSpiderContent"})
    public Json<ContentDTO> getSpiderContent(@RequestBody CrawlingParam crawlingParam) {
        return ResultUtil.genSuccessResult((Object)this.adminNewsService.getSpiderContent(crawlingParam));
    }

    @ApiOperation(value="1-7-12 \u65b0\u95fb\u901a\u8fc7\u5ba1\u6838")
    @PostMapping(value={"/review"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true), @ApiImplicitParam(name="review", value="\u662f\u5426\u901a\u8fc7\u5ba1\u6838 0:\u5f85\u5ba1\u6838  1:\u5df2\u62d2\u7edd  2:\u5df2\u901a\u8fc7  \u4f202\u4ee3\u8868\u5ba1\u6838\u901a\u8fc7", required=true)})
    public Json review(Long id, Byte review) {
        this.adminNewsService.review(id, review);
        return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
    }

    @ApiOperation(value="1-7-13 \u65b0\u95fb\u6279\u91cf\u901a\u8fc7\u5ba1\u6838")
    @PostMapping(value={"/batchReview"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u5b57\u7b26\u4e32\uff0c\u4ee5\u201d,\u201c\u5206\u9694", required=true), @ApiImplicitParam(name="review", value="\u662f\u5426\u901a\u8fc7\u5ba1\u6838 0:\u5f85\u5ba1\u6838  1:\u5df2\u62d2\u7edd  2:\u5df2\u901a\u8fc7", required=true)})
    public Json batchReview(String ids, Byte review) {
        String[] idArray = ids.split(",");
        if (idArray.length > 0) {
            this.adminNewsService.batchReview(ids, review);
            return ResultUtil.genSuccessResult((Object)"\u66f4\u65b0\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u8bf7\u9009\u62e9\u65b0\u95fb");
    }

    @ApiOperation(value="1-7-14 \u65b0\u95fb\u5c5e\u6027\u6807\u7b7e")
    @PostMapping(value={"/kind"})
    public Json<List<NewsTagDTO>> gelabelList() {
        ArrayList<NewsTagDTO> newsTagDTOList = new ArrayList<NewsTagDTO>();
        newsTagDTOList.add(new NewsTagDTO("\u6e38\u620f"));
        newsTagDTOList.add(new NewsTagDTO("\u7f8e\u5973"));
        newsTagDTOList.add(new NewsTagDTO("\u98ce\u666f"));
        newsTagDTOList.add(new NewsTagDTO("\u56fd\u9645"));
        return ResultUtil.genSuccessResult(newsTagDTOList);
    }

    @ApiOperation(value="1-7-15 \u83b7\u53d6\u65b0\u589e\u65b0\u95fbid")
    @GetMapping(value={"/getCreateId"})
    public Json<Long> getCreateId() {
        return ResultUtil.genSuccessResult((Object)this.adminNewsService.getCreateId());
    }

    @ApiOperation(value="1-7-16 \u65b0\u95fb\u6dfb\u52a0\u5230\u63a8\u8350\u5e93")
    @PostMapping(value={"/addNewsToMixRecommendPool"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u65b0\u95fbid", required=true), @ApiImplicitParam(name="origin", value="\u7c7b\u578b 1\uff1a\u793e\u533a\u5e16\u5b502\uff1a\u672c\u5730\u65b0\u95fb 3\uff1a\u5168\u56fd\u65b0\u95fb", required=true)})
    public Json addNewsToMixRecommendPool(MixPoolParam mixPoolParam) {
        String origin = mixPoolParam.getOrigin();
        if (StringUtils.isBlank((CharSequence)origin) || !"1".equals(origin) && !"2".equals(origin) && !"3".equals(origin)) {
            return ResultUtil.genFailedResult((String)"\u7c7b\u578b\u4e3a\u7a7a,\u6216\u4e0d\u5b58\u5728!");
        }
        int i = this.adminNewsService.addNewsToMixRecommendPool(mixPoolParam);
        if (i == 0) {
            return ResultUtil.genFailedResult((String)"\u6dfb\u52a0\u63a8\u8350\u5e93\u5931\u8d25,\u8bf7\u68c0\u67e5\u65b0\u95fb\u662f\u5426\u7f6e\u9876\u6216\u65b0\u95fb\u662f\u5426\u5b58\u5728!");
        }
        return ResultUtil.genSuccessMsg((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @ApiOperation(value="1-7-17 \u5c06\u65b0\u95fb\u4ece\u65b0\u95fb\u5e93\u4e2d\u5220\u9664")
    @PostMapping(value={"/deleteNewsById"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u65b0\u95fbid", required=true)})
    public Json deleteNewsById(Long id) {
        this.adminNewsService.deleteNewsById(id);
        return ResultUtil.genSuccessMsg((String)"\u5220\u9664\u6210\u529f!");
    }
}

