package com.bxm.localnews.admin.controller.activity;

import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.dto.CashDTO;
import com.bxm.localnews.admin.dto.FolwerDTO;
import com.bxm.localnews.admin.entry.UserAccountGrantFlow;
import com.bxm.localnews.admin.param.CashParam;
import com.bxm.localnews.admin.param.FlowerParam;
import com.bxm.localnews.admin.param.UserAccountGrantFlowParam;
import com.bxm.localnews.admin.service.activity.GiveOutCashService;
import com.bxm.localnews.admin.service.activity.GiveOutFlowerService;
import com.bxm.localnews.admin.vo.GoldFlow;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageParam;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author: gengyy
 * @create: 2020-10-21 18:19
 */
@Api(tags = "1-63 [管理]现金发放")
@RestController
@RequestMapping("/api/cash")
@AllArgsConstructor
public class GiveOutCashController extends CommonController {

    private GiveOutCashService giveOutCashService;

    @ApiOperation(value = "1-63-1 获得当前页面操作的唯一id", notes = "获得当前页面操作的唯一id")
    @GetMapping("/getUniquelyId")
    public ResponseJson<Long> getUniquelyId() {
        return ResponseJson.ok(giveOutCashService.getUniquelyId());
    }


    @ApiOperation(value = "1-63-2 发放现金接口", notes = "发放现金")
    @PostMapping("/giveOut")
    public ResponseJson<CashDTO> giveOutCash(@RequestBody CashParam cashParam) {
        String template = cashParam.getTemplate();
        if (StringUtils.isBlank(template)) {
            return ResponseJson.build(Message.build(false, "发放配置为空"));
        }
        return ResponseJson.ok(giveOutCashService.doSendCash(cashParam, this.getLoginUser()));
    }

    @ApiOperation(value = "1-63-3 发放现金列表", notes = "现金列表")
    @GetMapping("/list")
    public ResponseJson<PageWarper<UserAccountGrantFlow>> listFlower(UserAccountGrantFlowParam pageParam) {
        return ResponseJson.ok(giveOutCashService.listFlower(pageParam));
    }
}
