package com.bxm.localnews.admin.controller.activity;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.admin.dto.RedPacketConfigDTO;
import com.bxm.localnews.admin.dto.RedPacketContentDTO;
import com.bxm.localnews.admin.param.RedPacketConfigParam;
import com.bxm.localnews.admin.service.activity.RedPacketConfigService;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "1-46 [管理]口令红包配置相关接口", description = "红包配置相关接口")
@RestController
@RequestMapping("api/admin/packet/config")
public class RedPacketConfigController {

    /**
     * 日志对象
     */
    private static final Logger LOG = LoggerFactory.getLogger(RedPacketConfigController.class);

    /**
     * 红包配置服务
     */
    private RedPacketConfigService redPacketConfigService;

    @Autowired
    public RedPacketConfigController(RedPacketConfigService redPacketConfigService) {
        this.redPacketConfigService = redPacketConfigService;
    }

    @ApiOperation(value = "1-46-01 编辑红包配置", notes = "编辑红包配置")
    @PostMapping("/edit")
    public Json editRedPacketConfig(@RequestBody RedPacketConfigParam redPacketConfigParam) {

        if (!redPacketConfigService.editRedPacketConfig(redPacketConfigParam)) {
            LOG.error("编辑红包配置失败,请求参数为:{}", JSON.toJSONString(redPacketConfigParam));
            return ResultUtil.genFailedResult("编辑红包配置失败");
        }
        return ResultUtil.genSuccessResult("编辑红包配置成功");
    }

    @ApiOperation(value = "1-46-02 获取红包配置", notes = "获取红包配置")
    @PostMapping("/detail")
    public Json<RedPacketConfigDTO> getRedPacketConfig() {
        return ResultUtil.genSuccessResult(redPacketConfigService.getRedPacketConfig());
    }

    @ApiOperation(value = "1-46-08 新增红包配置", notes = "新增红包配置")
    @PostMapping("/add")
    public Json addRedPacketConfig(@RequestBody RedPacketConfigParam redPacketConfigParam) {
        if (!redPacketConfigService.addRedPacketConfig(redPacketConfigParam)) {
            LOG.error("新增红包配置失败,新增参数为", JSON.toJSONString(redPacketConfigParam));
            return ResultUtil.genFailedResult("新增红包配置失败");
        }
        return ResultUtil.genSuccessResult("新增红包配置成功");
    }
    //==============以下为口令红包模板接口=================

    @ApiOperation(value = "1-46-03 编辑红包口令模板", notes = "编辑红包口令模板")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "content", value = "红包口令内容", required = true)
    })
    @PostMapping("/content/edit")
    public Json editRedPacketContent(Long id, String content) {
        if (!redPacketConfigService.editRedPacketContent(id, content)) {
            LOG.error("编辑红包口令模板失败,id为:{}, 内容为:{}", id, content);
            return ResultUtil.genFailedResult("编辑红包口令模板失败");
        }
        return ResultUtil.genSuccessResult("编辑红包口令模板成功");
    }

    @ApiOperation(value = "1-46-04 获取红包口令模板详情", notes = "获取红包口令模板详情")
    @ApiImplicitParam(name = "id", value = "id", required = true)
    @PostMapping("/content/detail")
    public Json<RedPacketContentDTO> getRedPacketContentDetail(Long id) {

        RedPacketContentDTO redPacketContentDTO = redPacketConfigService.getContentDetail(id);

        if (null == redPacketContentDTO) {
            return ResultUtil.genFailedResult("获取红包口令模板详情为空");
        }
        return ResultUtil.genSuccessResult(redPacketContentDTO);
    }

    @ApiOperation(value = "1-46-05 获取红包口令模板列表", notes = "获取红包口令模板列表")
    @PostMapping("/content/list")
    public Json<PageWarper<RedPacketContentDTO>> getRedPacketContentList(RedPacketContentDTO redPacketContentDTO) {

        return ResultUtil.genSuccessResult(redPacketConfigService.getContentList(redPacketContentDTO));
    }

    @ApiOperation(value = "1-46-06 删除红包口令模板", notes = "删除红包口令模板")
    @ApiImplicitParam(name = "id", value = "id", required = true)
    @PostMapping("/content/del")
    public Json delRedPacketContent(Long id) {
        if (!redPacketConfigService.delContent(id)) {
            LOG.error("删除id为:{}的口令模板失败", id);
            return ResultUtil.genFailedResult("删除失败");
        }

        return ResultUtil.genSuccessResult("删除成功");
    }

    @ApiOperation(value = "1-46-07 新增口令模板", notes = "新增口令模板")
    @ApiImplicitParam(name = "content", value = "口令内容", required = true)
    @PostMapping("/content/add")
    public Json addRedPacketContent(String content) {
        if (!redPacketConfigService.addContent(content)) {
            LOG.error("新增口令模板失败");
            return ResultUtil.genFailedResult("新增口令模板失败");
        }

        return ResultUtil.genSuccessResult("新增口令模板成功");
    }

}
