package com.bxm.localnews.admin.controller.activity;

import com.bxm.localnews.admin.dto.AccountCashFlowDTO;
import com.bxm.localnews.admin.param.UserCashFlowParam;
import com.bxm.localnews.admin.service.user.UserAccountService;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author lowi
 * @date 2021/1/13 12:00
 */
@Api(tags = "1-65 用户账户模块")
@RestController
@RequestMapping("api/user/account")
public class UserAccountController {

    @Autowired
    private UserAccountService userAccountService;

    @ApiOperation(value = "1-65-1 获取用户资金流水")
    @ApiImplicitParam(name = "userId", value = "用户id")
    @GetMapping("getCashFlow")
    public ResponseJson<PageWarper<AccountCashFlowDTO>> getCashFlow(UserCashFlowParam userCashFlowParam) {
        return ResponseJson.ok(userAccountService.getCashFlow(userCashFlowParam));
    }

}
