package com.bxm.localnews.admin.controller.base;

import com.bxm.localnews.admin.dto.AppVersionDTO;
import com.bxm.localnews.admin.param.AppVersionParam;
import com.bxm.localnews.admin.service.base.AdminAppVersionService;
import com.bxm.localnews.admin.vo.AppVersion;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhaoyadong 2019/1/10 11:18
 * @desc
 */
@Api(tags = "1-25 [管理]App版本管理", description = "App版本管理的相关操作")
@RestController
@RequestMapping("api/admin/appversion")
public class AdminAppVersionController extends BaseController {

    private AdminAppVersionService adminAppVersionService;

    @Autowired
    public AdminAppVersionController(AdminAppVersionService adminAppVersionService) {
        this.adminAppVersionService = adminAppVersionService;
    }

    @ApiOperation(value = "1-25-1 获取App版本列表", notes = "根据输入参数获取对应的版本数据")
    @GetMapping("/list")
    public Json<PageWarper<AppVersionDTO>> getAppVersionList(AppVersionParam appVersionParam) {
        return ResultUtil.genSuccessResult(this.adminAppVersionService.getAppVersionList(appVersionParam));
    }

    @ApiOperation(value = "1-25-2 获取App版本详情", notes = "获取对应的版本详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true)
    })
    @GetMapping("/detail")
    public Json<AppVersionDTO> getAppVersionById(Long id) {
        return ResultUtil.genSuccessResult(this.adminAppVersionService.getAppVersionById(id));
    }

    @ApiOperation(value = "1-25-3 app版本信息批量更新审核状态和版本更新方式", notes = "", hidden = true)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id字符串，以”,“分隔", required = true),
            @ApiImplicitParam(name = "status", value = "状态", required = false),
            @ApiImplicitParam(name = "force", value = "更新方式", required = false)
    })
    @PostMapping("/batchUpdateStatus")
    public Json updateAppVersionStatusByIds(String ids, Byte status, Byte force) {
        if (StringUtils.isBlank(ids)) {
            return ResultUtil.genFailedResult("版本信息不存在");
        }
        String[] id = ids.split(",");
        if (this.adminAppVersionService.updateAppVersionStatusById(id, status, force) > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }

    @ApiOperation(value = "1-25-4 app版本信息更新审核状态和版本更新方式", notes = "")

    @PostMapping("/updateStatus")
    public Json updateAppVersionStatusById(AppVersion appVersion) {
        if (this.adminAppVersionService.updateAppVersionStatusById(appVersion) > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }

    @ApiOperation(value = "1-25-5 新增或编辑版本信息", notes = "")
    @PostMapping("/saveOrUpdateAppVersion")
    public Json addAdvertDetail(AppVersion appVersion) {
        if (this.adminAppVersionService.addAppVersionDetail(appVersion) > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }


}
