package com.bxm.localnews.admin.controller.base;

import com.bxm.localnews.admin.dto.LocationDTO;
import com.bxm.localnews.admin.param.ListLocationParam;
import com.bxm.localnews.admin.param.LocationPageParam;
import com.bxm.localnews.admin.param.LocationParam;
import com.bxm.localnews.admin.param.ModifyLocationParam;
import com.bxm.localnews.admin.service.base.LocationService;
import com.bxm.localnews.admin.vo.AreaInfo;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "1-05 [管理]行政区域管理", description = "行政区域管理的相关操作")
@RestController
@RequestMapping("api/admin/location")
@AllArgsConstructor
public class AdminLocationController {

    private LocationService locationService;

    @ApiOperation(value = "1-05-1 分页获取所有的城市信息", notes = "包含城市名称、拼音、最新的城市编码")
    @GetMapping("list")
    public ResponseJson<List<LocationDTO>> list(LocationPageParam param) {
        return ResponseJson.ok(locationService.listLocationByPage(param));
    }

    @ApiOperation(value = "1-05-2 编辑城市信息", notes = "更新最新的城市区域码等等")
    @PostMapping("modify")
    public ResponseJson modify(@RequestBody ModifyLocationParam param) {
        return locationService.modifyLocation(param);
    }

}
