package com.bxm.localnews.admin.controller.base;

import com.bxm.localnews.admin.param.TaskParam;
import com.bxm.localnews.admin.service.activity.TaskService;
import com.bxm.localnews.admin.vo.TaskBean;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "1-14 [管理]任务管理", description = "任务管理的相关操作")
@RestController
@RequestMapping("api/admin/task")
public class AdminTaskController extends BaseController {

    private TaskService taskService;

    @Autowired
    public AdminTaskController(TaskService taskService) {
        this.taskService = taskService;
    }

    @ApiOperation(value = "1-14-1 获取任务列表")
    @GetMapping("/list")
    public Json<PageWarper<TaskBean>> getTask(TaskParam param) {
        PageWarper<TaskBean> result = taskService.queryTaskByPage(param);
        return ResultUtil.genSuccessResult(result);
    }

    @ApiOperation(value = "1-14-2 任务批量上下架")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id字符串，以”,“分隔", required = true),
            @ApiImplicitParam(name = "state", value = "状态", required = true)
    })
    @PostMapping("/batchUpdateTasks")
    public Json updateNewsStatusByIds(String ids, Byte state) {
        Message result = this.taskService.modifyTaskStatus(state, StringUtils.split(ids, ","));
        return Json.build(result);
    }

    @ApiOperation(value = "1-14-3 获取任务详情")
    @ApiImplicitParam(name = "id", value = "任务id", required = true)
    @GetMapping("/getTaskDetail")
    public Json<TaskBean> getNewsDetail(Long id) {
        return ResultUtil.genSuccessResult(this.taskService.getTaskById(id));
    }

    @ApiOperation(value = "1-14-4 任务上下架")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "state", value = "状态", required = true)
    })
    @PostMapping("/updateTask")
    public Json updateNewsStatusById(Long id, Byte state) {
        return Json.build(taskService.modifyTaskStatus(state, id.toString()));
    }

}










