package com.bxm.localnews.admin.controller.base;

import com.bxm.localnews.admin.dto.EditorResult;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.tools.FileUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.ImmutableList;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@Api(tags = "1-61 [管理]文件上传管理", description = "文件管理的相关操作")
@RestController
@RequestMapping("api/admin/file")
public class FileController {

    private AliyunOSSService aliyunOSSService;

    /**
     * 仅对图片增加压缩参数，gif不支持压缩
     */
    private List<String> imageExtensions = ImmutableList.of("jpg", "png", "jpeg", "bmp");

    @Autowired
    public FileController(AliyunOSSService aliyunOSSService) {
        this.aliyunOSSService = aliyunOSSService;
    }

    @ApiOperation(value = "1-61-1 文件上传")
    @PostMapping("/upload")
    public Json<String> uploadFile(@RequestParam(value = "file") MultipartFile multipartFile) {
        String fileName = FileUtils.getFileName(multipartFile.getName());
        String extension = FileUtils.getFilextension(fileName);

        String uploadUrl = aliyunOSSService.upload(multipartFile);

        if (imageExtensions.stream().anyMatch(item -> StringUtils.equalsIgnoreCase(item, extension))) {
            uploadUrl += "?x-oss-process=style/scompress";
        }

        return ResultUtil.genSuccessResult(uploadUrl);
    }

    @ApiOperation(value = "1-61-2 编辑器文件上传")
    @PostMapping("/editor/upload")
    public EditorResult editorUploadFile(@RequestParam(value = "files") MultipartFile... multipartFile) {
        return new EditorResult(0, aliyunOSSService.upload(multipartFile));
    }
}
