package com.bxm.localnews.admin.controller.base;

import com.bxm.localnews.admin.service.base.AdvertisementService;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wzy
 * @version 1.0
 * @date 2020/9/29 5:35 下午
 */
@Api(tags = "1-63 [管理]执行一次广告位下线定时任务", description = "执行一次广告位下线定时任务")
@RestController
@RequestMapping("api/admin/offline")
public class OfflineAdvertController {
    @Autowired
    private AdvertisementService advertisementService;

    @ApiOperation(value = "1-63-1 执行扫描上架的广告位是否过期，如果过期则进行下架")
    @GetMapping("/advert")
    public ResponseJson<String> offlineAdvertPosition() {
        advertisementService.offlineAdvertPosition();
        return ResponseJson.ok().build();
    }
}